/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.morphia.converters.IdentityConverter;
import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.logging.Logger;
import me.lucko.helper.mongo.external.morphia.logging.MorphiaLoggerFactory;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.Mapper;
import me.lucko.helper.mongo.external.morphia.mapping.MapperOptions;
import me.lucko.helper.mongo.external.morphia.mapping.MappingException;

public abstract class Converters {
    private static final Logger LOG = MorphiaLoggerFactory.get(Converters.class);
    private final Mapper mapper;
    private final List<TypeConverter> untypedTypeEncoders = new LinkedList<TypeConverter>();
    private final Map<Class, List<TypeConverter>> tcMap = new ConcurrentHashMap<Class, List<TypeConverter>>();
    private final List<Class<? extends TypeConverter>> registeredConverterClasses = new ArrayList<Class<? extends TypeConverter>>();

    public Converters(Mapper mapper) {
        this.mapper = mapper;
    }

    public TypeConverter addConverter(Class<? extends TypeConverter> clazz) {
        return this.addConverter(this.mapper.getOptions().getObjectFactory().createInstance(clazz));
    }

    public TypeConverter addConverter(TypeConverter tc) {
        if (tc.getSupportedTypes() != null) {
            for (Class c : tc.getSupportedTypes()) {
                this.addTypedConverter(c, tc);
            }
        } else {
            this.untypedTypeEncoders.add(tc);
        }
        this.registeredConverterClasses.add(tc.getClass());
        tc.setMapper(this.mapper);
        return tc;
    }

    public Object decode(Class c, Object fromDBObject, MappedField mf) {
        Class<?> toDecode = c;
        if (toDecode == null) {
            toDecode = fromDBObject.getClass();
        }
        return this.getEncoder(toDecode).decode(toDecode, fromDBObject, mf);
    }

    public Object encode(Object o) {
        if (o == null) {
            return null;
        }
        return this.encode(o.getClass(), o);
    }

    public Object encode(Class c, Object o) {
        return this.getEncoder(c).encode(o);
    }

    public void fromDBObject(DBObject dbObj, MappedField mf, Object targetEntity) {
        Object object = mf.getDbObjectValue(dbObj);
        if (object != null) {
            TypeConverter enc = this.getEncoder(mf);
            Object decodedValue = enc.decode(mf.getType(), object, mf);
            try {
                mf.setFieldValue(targetEntity, decodedValue);
            }
            catch (IllegalArgumentException e) {
                throw new MappingException(String.format("Error setting value from converter (%s) for %s to %s", enc.getClass().getSimpleName(), mf.getFullName(), decodedValue), e);
            }
        }
    }

    public boolean hasDbObjectConverter(MappedField field) {
        TypeConverter converter = this.getEncoder(field);
        return converter != null && !(converter instanceof IdentityConverter) && !(converter instanceof SimpleValueConverter);
    }

    public boolean hasDbObjectConverter(Class c) {
        TypeConverter converter = this.getEncoder(c);
        return converter != null && !(converter instanceof IdentityConverter) && !(converter instanceof SimpleValueConverter);
    }

    public boolean hasSimpleValueConverter(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Class) {
            return this.hasSimpleValueConverter((Class)o);
        }
        if (o instanceof MappedField) {
            return this.hasSimpleValueConverter((MappedField)o);
        }
        return this.hasSimpleValueConverter(o.getClass());
    }

    public boolean hasSimpleValueConverter(Class c) {
        return this.getEncoder(c) instanceof SimpleValueConverter;
    }

    public boolean hasSimpleValueConverter(MappedField c) {
        return this.getEncoder(c) instanceof SimpleValueConverter;
    }

    public boolean isRegistered(Class<? extends TypeConverter> tcClass) {
        return this.registeredConverterClasses.contains(tcClass);
    }

    public void removeConverter(TypeConverter tc) {
        if (tc.getSupportedTypes() == null) {
            this.untypedTypeEncoders.remove(tc);
            this.registeredConverterClasses.remove(tc.getClass());
        } else {
            for (Map.Entry<Class, List<TypeConverter>> entry : this.tcMap.entrySet()) {
                List<TypeConverter> list = entry.getValue();
                if (list.contains(tc)) {
                    list.remove(tc);
                }
                if (!list.isEmpty()) continue;
                this.tcMap.remove(entry.getKey());
            }
            this.registeredConverterClasses.remove(tc.getClass());
        }
    }

    public void toDBObject(Object containingObject, MappedField mf, DBObject dbObj, MapperOptions opts) {
        Object fieldValue = mf.getFieldValue(containingObject);
        TypeConverter enc = this.getEncoder(fieldValue, mf);
        Object encoded = enc.encode(fieldValue, mf);
        if (encoded != null || opts.isStoreNulls()) {
            dbObj.put(mf.getNameToStore(), encoded);
        }
    }

    protected TypeConverter getEncoder(Class c) {
        List<TypeConverter> tcs = this.tcMap.get(c);
        if (tcs != null) {
            if (tcs.size() > 1) {
                LOG.warning("Duplicate converter for " + c + ", returning first one from " + tcs);
            }
            return tcs.get(0);
        }
        for (TypeConverter tc : this.untypedTypeEncoders) {
            if (!tc.canHandle(c)) continue;
            return tc;
        }
        return null;
    }

    protected TypeConverter getEncoder(Object val, MappedField mf) {
        List<TypeConverter> tcs = null;
        if (val != null) {
            tcs = this.tcMap.get(val.getClass());
        }
        if (tcs == null || !tcs.isEmpty() && tcs.get(0) instanceof IdentityConverter) {
            tcs = this.tcMap.get(mf.getType());
        }
        if (tcs != null) {
            if (tcs.size() > 1) {
                LOG.warning("Duplicate converter for " + mf.getType() + ", returning first one from " + tcs);
            }
            return tcs.get(0);
        }
        for (TypeConverter tc : this.untypedTypeEncoders) {
            if (!tc.canHandle(mf) && (val == null || !tc.isSupported(val.getClass(), mf))) continue;
            return tc;
        }
        return null;
    }

    private void addTypedConverter(Class type, TypeConverter tc) {
        if (this.tcMap.containsKey(type)) {
            this.tcMap.get(type).add(0, tc);
            LOG.warning("Added duplicate converter for " + type + " ; " + this.tcMap.get(type));
        } else {
            ArrayList<TypeConverter> values = new ArrayList<TypeConverter>();
            values.add(tc);
            this.tcMap.put(type, values);
        }
    }

    private TypeConverter getEncoder(MappedField mf) {
        return this.getEncoder(null, mf);
    }
}

