/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.MappingException;

public class ClassConverter
extends TypeConverter
implements SimpleValueConverter {
    public ClassConverter() {
        super(Class.class);
    }

    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        if (fromDBObject == null) {
            return null;
        }
        String l = fromDBObject.toString();
        try {
            return Class.forName(l);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Cannot create class from Name '" + l + "'", e);
        }
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return ((Class)value).getName();
    }
}

