/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.MappingException;

public class CharacterConverter
extends TypeConverter
implements SimpleValueConverter {
    public CharacterConverter() {
        super(Character.TYPE, Character.class);
    }

    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        if (fromDBObject == null) {
            return null;
        }
        if (fromDBObject instanceof String) {
            char[] chars = ((String)fromDBObject).toCharArray();
            if (chars.length == 1) {
                return Character.valueOf(chars[0]);
            }
            if (chars.length == 0) {
                return Character.valueOf('\u0000');
            }
        }
        throw new MappingException("Trying to map multi-character data to a single character: " + fromDBObject);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        return value == null || value.equals(Character.valueOf('\u0000')) ? null : String.valueOf(value);
    }
}

