/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.lang.reflect.Array;
import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;

public class CharArrayConverter
extends TypeConverter
implements SimpleValueConverter {
    public CharArrayConverter() {
        super(char[].class, Character[].class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        char[] chars = val.toString().toCharArray();
        if (targetClass.isArray() && targetClass.equals(Character[].class)) {
            return this.convertToWrapperArray(chars);
        }
        return chars;
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        Character[] array;
        if (value == null) {
            return null;
        }
        if (value instanceof char[]) {
            return new String((char[])value);
        }
        StringBuilder builder = new StringBuilder();
        for (Character character : array = (Character[])value) {
            builder.append(character);
        }
        return builder.toString();
    }

    Object convertToWrapperArray(char[] values) {
        int length = values.length;
        Object array = Array.newInstance(Character.class, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, Character.valueOf(values[i]));
        }
        return array;
    }
}

