/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia;

import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.client.model.DBCollectionFindAndModifyOptions;

public final class FindAndModifyOptions {
    private DBCollectionFindAndModifyOptions options = new DBCollectionFindAndModifyOptions().returnNew(true);

    FindAndModifyOptions copy() {
        FindAndModifyOptions copy = new FindAndModifyOptions();
        copy.bypassDocumentValidation(this.getBypassDocumentValidation());
        copy.collation(this.getCollation());
        copy.maxTime(this.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        copy.projection(this.getProjection());
        copy.remove(this.isRemove());
        copy.returnNew(this.isReturnNew());
        copy.sort(this.getSort());
        copy.update(this.getUpdate());
        copy.upsert(this.isUpsert());
        copy.writeConcern(this.getWriteConcern());
        return copy;
    }

    DBCollectionFindAndModifyOptions getOptions() {
        return this.copy().options;
    }

    DBObject getProjection() {
        return this.options.getProjection();
    }

    FindAndModifyOptions projection(DBObject projection) {
        this.options.projection(projection);
        return this;
    }

    DBObject getSort() {
        return this.options.getSort();
    }

    FindAndModifyOptions sort(DBObject sort) {
        this.options.sort(sort);
        return this;
    }

    public boolean isRemove() {
        return this.options.isRemove();
    }

    public FindAndModifyOptions remove(boolean remove) {
        this.options.remove(remove);
        return this;
    }

    DBObject getUpdate() {
        return this.options.getUpdate();
    }

    FindAndModifyOptions update(DBObject update) {
        this.options.update(update);
        return this;
    }

    public boolean isUpsert() {
        return this.options.isUpsert();
    }

    public FindAndModifyOptions upsert(boolean upsert) {
        this.options.upsert(upsert);
        return this;
    }

    public boolean isReturnNew() {
        return this.options.returnNew();
    }

    public FindAndModifyOptions returnNew(boolean returnNew) {
        this.options.returnNew(returnNew);
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.options.getBypassDocumentValidation();
    }

    public FindAndModifyOptions bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.options.bypassDocumentValidation(bypassDocumentValidation);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return this.options.getMaxTime(timeUnit);
    }

    public FindAndModifyOptions maxTime(long maxTime, TimeUnit timeUnit) {
        this.options.maxTime(maxTime, timeUnit);
        return this;
    }

    public WriteConcern getWriteConcern() {
        return this.options.getWriteConcern();
    }

    public FindAndModifyOptions writeConcern(WriteConcern writeConcern) {
        this.options.writeConcern(writeConcern);
        return this;
    }

    public Collation getCollation() {
        return this.options.getCollation();
    }

    public FindAndModifyOptions collation(Collation collation) {
        this.options.collation(collation);
        return this;
    }
}

