/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.selector;

import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterConnectionMode;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;
import me.lucko.helper.mongo.external.mongodriver.selector.ServerSelector;

public class ReadPreferenceServerSelector
implements ServerSelector {
    private final ReadPreference readPreference;

    public ReadPreferenceServerSelector(ReadPreference readPreference) {
        this.readPreference = Assertions.notNull("readPreference", readPreference);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return clusterDescription.getAny();
        }
        return this.readPreference.choose(clusterDescription);
    }

    public String toString() {
        return "ReadPreferenceServerSelector{readPreference=" + this.readPreference + '}';
    }
}

