/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncReadBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadBinding;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;

public class UserExistsOperation
implements AsyncReadOperation<Boolean>,
ReadOperation<Boolean> {
    private final String databaseName;
    private final String userName;

    public UserExistsOperation(String databaseName, String userName) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.userName = Assertions.notNull("userName", userName);
    }

    @Override
    public Boolean execute(final ReadBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Boolean>(){

            @Override
            public Boolean call(Connection connection) {
                return (Boolean)CommandOperationHelper.executeWrappedCommandProtocol(binding, UserExistsOperation.this.databaseName, UserExistsOperation.this.getCommand(), connection, UserExistsOperation.this.transformer());
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<Boolean> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                    CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, UserExistsOperation.this.databaseName, UserExistsOperation.this.getCommand(), (Decoder<BsonDocument>)new BsonDocumentCodec(), connection, UserExistsOperation.this.transformer(), wrappedCallback);
                }
            }
        });
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, Boolean> transformer() {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, Boolean>(){

            @Override
            public Boolean apply(BsonDocument result, ServerAddress serverAddress) {
                return result.get("users").isArray() && !result.getArray("users").isEmpty();
            }
        };
    }

    private BsonDocument getCommand() {
        return new BsonDocument("usersInfo", new BsonString(this.userName));
    }
}

