/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ReadConcernLevel;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

final class ReadConcernHelper {
    static void appendReadConcernToCommand(ReadConcern readConcern, SessionContext sessionContext, BsonDocument commandDocument) {
        Assertions.notNull("readConcern", readConcern);
        Assertions.notNull("sessionContext", sessionContext);
        Assertions.notNull("commandDocument", commandDocument);
        BsonDocument readConcernDocument = new BsonDocument();
        ReadConcernLevel level = ReadConcernHelper.getReadConcernLevel(readConcern, sessionContext);
        if (level != null) {
            readConcernDocument.append("level", new BsonString(level.getValue()));
        }
        if (ReadConcernHelper.shouldAddAfterClusterTime(sessionContext)) {
            readConcernDocument.append("afterClusterTime", sessionContext.getOperationTime());
        }
        if (!readConcernDocument.isEmpty()) {
            commandDocument.append("readConcern", readConcernDocument);
        }
    }

    private static ReadConcernLevel getReadConcernLevel(ReadConcern readConcern, SessionContext sessionContext) {
        if (readConcern.getLevel() == null && ReadConcernHelper.shouldAddAfterClusterTime(sessionContext)) {
            return ReadConcernLevel.LOCAL;
        }
        return readConcern.getLevel();
    }

    private static boolean shouldAddAfterClusterTime(SessionContext sessionContext) {
        return sessionContext.isCausallyConsistent() && sessionContext.getOperationTime() != null;
    }

    private ReadConcernHelper() {
    }
}

