/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonBoolean;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt32;
import me.lucko.helper.mongo.external.bson.BsonJavaScript;
import me.lucko.helper.mongo.external.bson.BsonNull;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.BsonValue;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.ExplainVerbosity;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncReadBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.ConnectionSource;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadBinding;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.QueryResult;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.internal.connection.NoOpSessionContext;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.BsonDocumentWrapperHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandResultDocumentCodec;
import me.lucko.helper.mongo.external.mongodriver.operation.DocumentHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.ExplainHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.MapReduceAsyncBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.MapReduceBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.MapReduceHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.MapReduceInlineResultsAsyncCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.MapReduceInlineResultsCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadConcernHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

public class MapReduceWithInlineResultsOperation<T>
implements AsyncReadOperation<MapReduceAsyncBatchCursor<T>>,
ReadOperation<MapReduceBatchCursor<T>> {
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final Decoder<T> decoder;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private long maxTimeMS;
    private ReadConcern readConcern = ReadConcern.DEFAULT;
    private Collation collation;

    public MapReduceWithInlineResultsOperation(MongoNamespace namespace, BsonJavaScript mapFunction, BsonJavaScript reduceFunction, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceWithInlineResultsOperation<T> finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceWithInlineResultsOperation<T> scope(BsonDocument scope) {
        this.scope = scope;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceWithInlineResultsOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceWithInlineResultsOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceWithInlineResultsOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceWithInlineResultsOperation<T> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceWithInlineResultsOperation<T> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public MapReduceWithInlineResultsOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public MapReduceWithInlineResultsOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public MapReduceWithInlineResultsOperation<T> readConcern(ReadConcern readConcern) {
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        return this;
    }

    @Override
    public MapReduceBatchCursor<T> execute(final ReadBinding binding) {
        return (MapReduceBatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<MapReduceBatchCursor<T>>(){

            @Override
            public MapReduceBatchCursor<T> call(ConnectionSource source, Connection connection) {
                OperationHelper.validateReadConcernAndCollation(connection, MapReduceWithInlineResultsOperation.this.readConcern, MapReduceWithInlineResultsOperation.this.collation);
                return (MapReduceBatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(binding, MapReduceWithInlineResultsOperation.this.namespace.getDatabaseName(), MapReduceWithInlineResultsOperation.this.getCommand(binding.getSessionContext()), CommandResultDocumentCodec.create(MapReduceWithInlineResultsOperation.this.decoder, "results"), connection, MapReduceWithInlineResultsOperation.this.transformer(source, connection));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<MapReduceAsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                    OperationHelper.validateReadConcernAndCollation(connection, MapReduceWithInlineResultsOperation.this.readConcern, MapReduceWithInlineResultsOperation.this.collation, new OperationHelper.AsyncCallableWithConnection(){

                        @Override
                        public void call(AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, MapReduceWithInlineResultsOperation.this.namespace.getDatabaseName(), MapReduceWithInlineResultsOperation.this.getCommand(binding.getSessionContext()), CommandResultDocumentCodec.create(MapReduceWithInlineResultsOperation.this.decoder, "results"), connection, MapReduceWithInlineResultsOperation.this.asyncTransformer(connection), wrappedCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.namespace.getDatabaseName(), ExplainHelper.asExplainCommand(this.getCommand(NoOpSessionContext.INSTANCE), explainVerbosity), new BsonDocumentCodec());
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, MapReduceBatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, MapReduceBatchCursor<T>>(){

            @Override
            public MapReduceBatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                return new MapReduceInlineResultsCursor(MapReduceWithInlineResultsOperation.this.createQueryResult(result, connection.getDescription()), MapReduceWithInlineResultsOperation.this.decoder, source, MapReduceHelper.createStatistics(result));
            }
        };
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, MapReduceAsyncBatchCursor<T>> asyncTransformer(final AsyncConnection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, MapReduceAsyncBatchCursor<T>>(){

            @Override
            public MapReduceAsyncBatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                return new MapReduceInlineResultsAsyncCursor(MapReduceWithInlineResultsOperation.this.createQueryResult(result, connection.getDescription()), MapReduceHelper.createStatistics(result));
            }
        };
    }

    private BsonDocument getCommand(SessionContext sessionContext) {
        BsonDocument commandDocument = new BsonDocument("mapreduce", new BsonString(this.namespace.getCollectionName())).append("map", this.getMapFunction()).append("reduce", this.getReduceFunction()).append("out", new BsonDocument("inline", new BsonInt32(1))).append("query", MapReduceWithInlineResultsOperation.asValueOrNull(this.getFilter())).append("sort", MapReduceWithInlineResultsOperation.asValueOrNull(this.getSort())).append("finalize", MapReduceWithInlineResultsOperation.asValueOrNull(this.getFinalizeFunction())).append("scope", MapReduceWithInlineResultsOperation.asValueOrNull(this.getScope())).append("verbose", BsonBoolean.valueOf(this.isVerbose()));
        ReadConcernHelper.appendReadConcernToCommand(this.readConcern, sessionContext, commandDocument);
        DocumentHelper.putIfNotZero(commandDocument, "limit", this.getLimit());
        DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        DocumentHelper.putIfTrue(commandDocument, "jsMode", this.isJsMode());
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        return commandDocument;
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, "results"), 0L, description.getServerAddress());
    }

    private static BsonValue asValueOrNull(BsonValue value) {
        return value == null ? BsonNull.VALUE : value;
    }
}

