/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonJavaScript;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.AsyncBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncReadBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.ConnectionSource;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadBinding;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.QueryResult;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncSingleBatchQueryCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.BatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.BsonDocumentWrapperHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandResultDocumentCodec;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.QueryBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;

public class GroupOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private final BsonJavaScript reduceFunction;
    private final BsonDocument initial;
    private BsonDocument key;
    private BsonJavaScript keyFunction;
    private BsonDocument filter;
    private BsonJavaScript finalizeFunction;
    private Collation collation;

    public GroupOperation(MongoNamespace namespace, BsonJavaScript reduceFunction, BsonDocument initial, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.initial = Assertions.notNull("initial", initial);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getKey() {
        return this.key;
    }

    public GroupOperation<T> key(BsonDocument key) {
        this.key = key;
        return this;
    }

    public BsonJavaScript getKeyFunction() {
        return this.keyFunction;
    }

    public GroupOperation<T> keyFunction(BsonJavaScript keyFunction) {
        this.keyFunction = keyFunction;
        return this;
    }

    public BsonDocument getInitial() {
        return this.initial;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public GroupOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public GroupOperation<T> finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public GroupOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public BatchCursor<T> execute(final ReadBinding binding) {
        return (BatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<BatchCursor<T>>(){

            @Override
            public BatchCursor<T> call(ConnectionSource connectionSource, Connection connection) {
                OperationHelper.validateCollation(connection, GroupOperation.this.collation);
                return (BatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(binding, GroupOperation.this.namespace.getDatabaseName(), GroupOperation.this.getCommand(), CommandResultDocumentCodec.create(GroupOperation.this.decoder, "retval"), connection, GroupOperation.this.transformer(connectionSource, connection));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                    OperationHelper.validateCollation(connection, GroupOperation.this.collation, new OperationHelper.AsyncCallableWithConnection(){

                        @Override
                        public void call(AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, GroupOperation.this.namespace.getDatabaseName(), GroupOperation.this.getCommand(), CommandResultDocumentCodec.create(GroupOperation.this.decoder, "retval"), connection, GroupOperation.this.asyncTransformer(connection), wrappedCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("ns", new BsonString(this.namespace.getCollectionName()));
        if (this.getKey() != null) {
            commandDocument.put("key", this.getKey());
        } else if (this.getKeyFunction() != null) {
            commandDocument.put("$keyf", this.getKeyFunction());
        }
        commandDocument.put("initial", this.getInitial());
        commandDocument.put("$reduce", this.getReduceFunction());
        if (this.getFinalizeFunction() != null) {
            commandDocument.put("finalize", this.getFinalizeFunction());
        }
        if (this.getFilter() != null) {
            commandDocument.put("cond", this.getFilter());
        }
        if (this.getCollation() != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        return new BsonDocument("group", commandDocument);
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                return new QueryBatchCursor(GroupOperation.this.createQueryResult(result, connection.getDescription()), 0, 0, GroupOperation.this.decoder, source);
            }
        };
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>> asyncTransformer(final AsyncConnection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                return new AsyncSingleBatchQueryCursor(GroupOperation.this.createQueryResult(result, connection.getDescription()));
            }
        };
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, "retval"), 0L, description.getServerAddress());
    }
}

