/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonArray;
import me.lucko.helper.mongo.external.bson.BsonBoolean;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt64;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.FieldNameValidator;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.MappedFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.UpdateFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.operation.BaseFindAndModifyOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.DocumentHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

public class FindAndUpdateOperation<T>
extends BaseFindAndModifyOperation<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private final BsonDocument update;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private long maxTimeMS;
    private boolean returnOriginal = true;
    private boolean upsert;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private List<BsonDocument> arrayFilters;

    @Deprecated
    public FindAndUpdateOperation(MongoNamespace namespace, Decoder<T> decoder, BsonDocument update) {
        this(namespace, WriteConcern.ACKNOWLEDGED, false, decoder, update);
    }

    @Deprecated
    public FindAndUpdateOperation(MongoNamespace namespace, WriteConcern writeConcern, Decoder<T> decoder, BsonDocument update) {
        this(namespace, writeConcern, false, decoder, update);
    }

    public FindAndUpdateOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder, BsonDocument update) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.decoder = Assertions.notNull("decoder", decoder);
        this.update = Assertions.notNull("decoder", update);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getUpdate() {
        return this.update;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindAndUpdateOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindAndUpdateOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindAndUpdateOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindAndUpdateOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndUpdateOperation<T> returnOriginal(boolean returnOriginal) {
        this.returnOriginal = returnOriginal;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndUpdateOperation<T> upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindAndUpdateOperation<T> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindAndUpdateOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public FindAndUpdateOperation<T> arrayFilters(List<BsonDocument> arrayFilters) {
        this.arrayFilters = arrayFilters;
        return this;
    }

    public List<BsonDocument> getArrayFilters() {
        return this.arrayFilters;
    }

    @Override
    protected String getDatabaseName() {
        return this.namespace.getDatabaseName();
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        HashMap<String, FieldNameValidator> map = new HashMap<String, FieldNameValidator>();
        map.put("update", new UpdateFieldNameValidator());
        return new MappedFieldNameValidator(new NoOpFieldNameValidator(), map);
    }

    @Override
    protected CommandOperationHelper.CommandCreator getCommandCreator(final SessionContext sessionContext) {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                OperationHelper.validateCollation(connectionDescription, FindAndUpdateOperation.this.collation);
                BsonDocument commandDocument = new BsonDocument("findandmodify", new BsonString(FindAndUpdateOperation.this.namespace.getCollectionName()));
                DocumentHelper.putIfNotNull(commandDocument, "query", FindAndUpdateOperation.this.getFilter());
                DocumentHelper.putIfNotNull(commandDocument, "fields", FindAndUpdateOperation.this.getProjection());
                DocumentHelper.putIfNotNull(commandDocument, "sort", FindAndUpdateOperation.this.getSort());
                DocumentHelper.putIfTrue(commandDocument, "new", !FindAndUpdateOperation.this.isReturnOriginal());
                DocumentHelper.putIfTrue(commandDocument, "upsert", FindAndUpdateOperation.this.isUpsert());
                DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", FindAndUpdateOperation.this.getMaxTime(TimeUnit.MILLISECONDS));
                commandDocument.put("update", FindAndUpdateOperation.this.getUpdate());
                if (FindAndUpdateOperation.this.bypassDocumentValidation != null && OperationHelper.serverIsAtLeastVersionThreeDotTwo(connectionDescription)) {
                    commandDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(FindAndUpdateOperation.this.bypassDocumentValidation));
                }
                if (FindAndUpdateOperation.this.writeConcern.isAcknowledged() && !FindAndUpdateOperation.this.writeConcern.isServerDefault() && OperationHelper.serverIsAtLeastVersionThreeDotTwo(connectionDescription)) {
                    commandDocument.put("writeConcern", FindAndUpdateOperation.this.writeConcern.asDocument());
                }
                if (FindAndUpdateOperation.this.collation != null) {
                    commandDocument.put("collation", FindAndUpdateOperation.this.collation.asDocument());
                }
                if (FindAndUpdateOperation.this.arrayFilters != null) {
                    commandDocument.put("arrayFilters", new BsonArray(FindAndUpdateOperation.this.arrayFilters));
                }
                if (OperationHelper.isRetryableWrite(FindAndUpdateOperation.this.retryWrites, FindAndUpdateOperation.this.writeConcern, serverDescription, connectionDescription)) {
                    commandDocument.put("txnNumber", new BsonInt64(sessionContext.advanceTransactionNumber()));
                }
                return commandDocument;
            }
        };
    }
}

