/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonBoolean;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt64;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.FieldNameValidator;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.CollectibleDocumentFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.MappedFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.operation.BaseFindAndModifyOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.DocumentHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

public class FindAndReplaceOperation<T>
extends BaseFindAndModifyOperation<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private final BsonDocument replacement;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private long maxTimeMS;
    private boolean returnOriginal = true;
    private boolean upsert;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    @Deprecated
    public FindAndReplaceOperation(MongoNamespace namespace, Decoder<T> decoder, BsonDocument replacement) {
        this(namespace, WriteConcern.ACKNOWLEDGED, false, decoder, replacement);
    }

    @Deprecated
    public FindAndReplaceOperation(MongoNamespace namespace, WriteConcern writeConcern, Decoder<T> decoder, BsonDocument replacement) {
        this(namespace, writeConcern, false, decoder, replacement);
    }

    public FindAndReplaceOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder, BsonDocument replacement) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.decoder = Assertions.notNull("decoder", decoder);
        this.replacement = Assertions.notNull("replacement", replacement);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getReplacement() {
        return this.replacement;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindAndReplaceOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindAndReplaceOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindAndReplaceOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindAndReplaceOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndReplaceOperation<T> returnOriginal(boolean returnOriginal) {
        this.returnOriginal = returnOriginal;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndReplaceOperation<T> upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindAndReplaceOperation<T> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindAndReplaceOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    protected String getDatabaseName() {
        return this.namespace.getDatabaseName();
    }

    @Override
    protected CommandOperationHelper.CommandCreator getCommandCreator(final SessionContext sessionContext) {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                OperationHelper.validateCollation(connectionDescription, FindAndReplaceOperation.this.collation);
                BsonDocument commandDocument = new BsonDocument("findandmodify", new BsonString(FindAndReplaceOperation.this.namespace.getCollectionName()));
                DocumentHelper.putIfNotNull(commandDocument, "query", FindAndReplaceOperation.this.getFilter());
                DocumentHelper.putIfNotNull(commandDocument, "fields", FindAndReplaceOperation.this.getProjection());
                DocumentHelper.putIfNotNull(commandDocument, "sort", FindAndReplaceOperation.this.getSort());
                DocumentHelper.putIfTrue(commandDocument, "new", !FindAndReplaceOperation.this.isReturnOriginal());
                DocumentHelper.putIfTrue(commandDocument, "upsert", FindAndReplaceOperation.this.isUpsert());
                DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", FindAndReplaceOperation.this.getMaxTime(TimeUnit.MILLISECONDS));
                commandDocument.put("update", FindAndReplaceOperation.this.getReplacement());
                if (FindAndReplaceOperation.this.bypassDocumentValidation != null && OperationHelper.serverIsAtLeastVersionThreeDotTwo(connectionDescription)) {
                    commandDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(FindAndReplaceOperation.this.bypassDocumentValidation));
                }
                if (FindAndReplaceOperation.this.writeConcern.isAcknowledged() && !FindAndReplaceOperation.this.writeConcern.isServerDefault() && OperationHelper.serverIsAtLeastVersionThreeDotTwo(connectionDescription)) {
                    commandDocument.put("writeConcern", FindAndReplaceOperation.this.writeConcern.asDocument());
                }
                if (FindAndReplaceOperation.this.collation != null) {
                    commandDocument.put("collation", FindAndReplaceOperation.this.collation.asDocument());
                }
                if (OperationHelper.isRetryableWrite(FindAndReplaceOperation.this.retryWrites, FindAndReplaceOperation.this.writeConcern, serverDescription, connectionDescription)) {
                    commandDocument.put("txnNumber", new BsonInt64(sessionContext.advanceTransactionNumber()));
                }
                return commandDocument;
            }
        };
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        HashMap<String, FieldNameValidator> map = new HashMap<String, FieldNameValidator>();
        map.put("update", new CollectibleDocumentFieldNameValidator());
        return new MappedFieldNameValidator(new NoOpFieldNameValidator(), map);
    }
}

