/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import me.lucko.helper.mongo.external.bson.BsonBoolean;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt32;
import me.lucko.helper.mongo.external.mongodriver.MongoWriteConcernException;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.WriteConcernResult;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteConcernError;
import me.lucko.helper.mongo.external.mongodriver.operation.BsonDocumentWrapperHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;

final class FindAndModifyHelper {
    static <T> CommandOperationHelper.CommandTransformer<BsonDocument, T> transformer() {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result, ServerAddress serverAddress) {
                if (result.containsKey("writeConcernError")) {
                    throw new MongoWriteConcernException(FindAndModifyHelper.createWriteConcernError(result.getDocument("writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result.getDocument("lastErrorObject", new BsonDocument())), serverAddress);
                }
                if (!result.isDocument("value")) {
                    return null;
                }
                return BsonDocumentWrapperHelper.toDocument(result.getDocument("value", null));
            }
        };
    }

    private static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber("code").intValue(), writeConcernErrorDocument.getString("errmsg").getValue(), writeConcernErrorDocument.getDocument("errInfo", new BsonDocument()));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result) {
        BsonBoolean updatedExisting = result.getBoolean("updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result.getNumber("n", new BsonInt32(0)).intValue(), updatedExisting.getValue(), result.get("upserted"));
    }

    private FindAndModifyHelper() {
    }
}

