/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.mongodriver.ExplainVerbosity;
import me.lucko.helper.mongo.external.mongodriver.MongoInternalException;

final class ExplainHelper {
    static BsonDocument asExplainCommand(BsonDocument command, ExplainVerbosity explainVerbosity) {
        return new BsonDocument("explain", command).append("verbosity", ExplainHelper.getVerbosityAsString(explainVerbosity));
    }

    private static BsonString getVerbosityAsString(ExplainVerbosity explainVerbosity) {
        switch (explainVerbosity) {
            case QUERY_PLANNER: {
                return new BsonString("queryPlanner");
            }
            case EXECUTION_STATS: {
                return new BsonString("executionStats");
            }
            case ALL_PLANS_EXECUTIONS: {
                return new BsonString("allPlansExecution");
            }
        }
        throw new MongoInternalException(String.format("Unsupported explain verbosity %s", new Object[]{explainVerbosity}));
    }

    private ExplainHelper() {
    }
}

