/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.AsyncBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncConnectionSource;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncReadBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.ConnectionSource;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadBinding;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.QueryResult;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncSingleBatchQueryCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.BatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.BsonDocumentWrapperHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandResultDocumentCodec;
import me.lucko.helper.mongo.external.mongodriver.operation.DocumentHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.QueryBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadConcernHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

public class DistinctOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String VALUES = "values";
    private final MongoNamespace namespace;
    private final String fieldName;
    private final Decoder<T> decoder;
    private BsonDocument filter;
    private long maxTimeMS;
    private ReadConcern readConcern = ReadConcern.DEFAULT;
    private Collation collation;

    public DistinctOperation(MongoNamespace namespace, String fieldName, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.fieldName = Assertions.notNull("fieldName", fieldName);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public DistinctOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DistinctOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public DistinctOperation<T> readConcern(ReadConcern readConcern) {
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public DistinctOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public BatchCursor<T> execute(final ReadBinding binding) {
        return (BatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<BatchCursor<T>>(){

            @Override
            public BatchCursor<T> call(ConnectionSource source, Connection connection) {
                OperationHelper.validateReadConcernAndCollation(connection, DistinctOperation.this.readConcern, DistinctOperation.this.collation);
                return (BatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(binding, DistinctOperation.this.namespace.getDatabaseName(), DistinctOperation.this.getCommand(binding.getSessionContext()), (Decoder<BsonDocument>)DistinctOperation.this.createCommandDecoder(), connection, DistinctOperation.this.transformer(source, connection));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnectionAndSource(){

            @Override
            public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, source, connection);
                    OperationHelper.validateReadConcernAndCollation(source, connection, DistinctOperation.this.readConcern, DistinctOperation.this.collation, new OperationHelper.AsyncCallableWithConnectionAndSource(){

                        @Override
                        public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, DistinctOperation.this.namespace.getDatabaseName(), DistinctOperation.this.getCommand(binding.getSessionContext()), (Decoder<BsonDocument>)DistinctOperation.this.createCommandDecoder(), connection, DistinctOperation.this.asyncTransformer(connection.getDescription()), wrappedCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, VALUES);
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, VALUES), 0L, description.getServerAddress());
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                QueryResult queryResult = DistinctOperation.this.createQueryResult(result, connection.getDescription());
                return new QueryBatchCursor(queryResult, 0, 0, DistinctOperation.this.decoder, source);
            }
        };
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>> asyncTransformer(final ConnectionDescription connectionDescription) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                QueryResult queryResult = DistinctOperation.this.createQueryResult(result, connectionDescription);
                return new AsyncSingleBatchQueryCursor(queryResult);
            }
        };
    }

    private BsonDocument getCommand(SessionContext sessionContext) {
        BsonDocument commandDocument = new BsonDocument("distinct", new BsonString(this.namespace.getCollectionName()));
        ReadConcernHelper.appendReadConcernToCommand(this.readConcern, sessionContext, commandDocument);
        commandDocument.put("key", new BsonString(this.fieldName));
        DocumentHelper.putIfNotNull(commandDocument, "query", this.filter);
        DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", this.maxTimeMS);
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        return commandDocument;
    }
}

