/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonDocumentWrapper;
import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonType;
import me.lucko.helper.mongo.external.bson.BsonValue;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistries;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandResultArrayCodec;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandResultCodecProvider;

class CommandResultDocumentCodec<T>
extends BsonDocumentCodec {
    private final Decoder<T> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultDocumentCodec(CodecRegistry registry, Decoder<T> payloadDecoder, List<String> fieldsContainingPayload) {
        super(registry);
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldsContainingPayload;
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, String fieldContainingPayload) {
        return CommandResultDocumentCodec.create(decoder, Collections.singletonList(fieldContainingPayload));
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, List<String> fieldsContainingPayload) {
        CodecRegistry registry = CodecRegistries.fromProviders(new CommandResultCodecProvider<P>(decoder, fieldsContainingPayload));
        return registry.get(BsonDocument.class);
    }

    @Override
    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        if (this.fieldsContainingPayload.contains(reader.getCurrentName())) {
            if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new BsonDocumentWrapper<T>(this.payloadDecoder.decode(reader, decoderContext), null);
            }
            if (reader.getCurrentBsonType() == BsonType.ARRAY) {
                return new CommandResultArrayCodec<T>(this.getCodecRegistry(), this.payloadDecoder).decode(reader, decoderContext);
            }
        }
        return super.readValue(reader, decoderContext);
    }
}

