/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.RawBsonDocument;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.bson.codecs.RawBsonDocumentCodec;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.AsyncBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncReadBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadBinding;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.client.model.changestream.FullDocument;
import me.lucko.helper.mongo.external.mongodriver.operation.AggregateOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncChangeStreamBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.BatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.ChangeStreamBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;

public class ChangeStreamOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final RawBsonDocumentCodec RAW_BSON_DOCUMENT_CODEC = new RawBsonDocumentCodec();
    private final MongoNamespace namespace;
    private final FullDocument fullDocument;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private BsonDocument resumeToken;
    private Integer batchSize;
    private Collation collation;
    private long maxAwaitTimeMS;
    private ReadConcern readConcern = ReadConcern.DEFAULT;

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public BsonDocument getResumeToken() {
        return this.resumeToken;
    }

    public ChangeStreamOperation<T> resumeAfter(BsonDocument resumeToken) {
        this.resumeToken = resumeToken;
        return this;
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ChangeStreamOperation<T> batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public ChangeStreamOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime >= 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public ChangeStreamOperation<T> readConcern(ReadConcern readConcern) {
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public ChangeStreamOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return new ChangeStreamBatchCursor(this, (BatchCursor<RawBsonDocument>)this.createAggregateOperation().execute(binding), binding);
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.createAggregateOperation().executeAsync(binding, new SingleResultCallback<AsyncBatchCursor<RawBsonDocument>>(){

            @Override
            public void onResult(AsyncBatchCursor<RawBsonDocument> result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new AsyncChangeStreamBatchCursor(ChangeStreamOperation.this, result, binding), null);
                }
            }
        });
    }

    private AggregateOperation<RawBsonDocument> createAggregateOperation() {
        ArrayList<BsonDocument> changeStreamPipeline = new ArrayList<BsonDocument>();
        BsonDocument changeStream = new BsonDocument("fullDocument", new BsonString(this.fullDocument.getValue()));
        if (this.resumeToken != null) {
            changeStream.append("resumeAfter", this.resumeToken);
        }
        changeStreamPipeline.add(new BsonDocument("$changeStream", changeStream));
        changeStreamPipeline.addAll(this.pipeline);
        return new AggregateOperation<RawBsonDocument>(this.namespace, changeStreamPipeline, RAW_BSON_DOCUMENT_CODEC).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS).readConcern(this.readConcern).batchSize(this.batchSize).collation(this.collation);
    }
}

