/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.RawBsonDocument;
import me.lucko.helper.mongo.external.mongodriver.MongoChangeStreamException;
import me.lucko.helper.mongo.external.mongodriver.MongoCursorNotFoundException;
import me.lucko.helper.mongo.external.mongodriver.MongoNotPrimaryException;
import me.lucko.helper.mongo.external.mongodriver.MongoSocketException;
import me.lucko.helper.mongo.external.mongodriver.async.AsyncBatchCursor;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncReadBinding;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.operation.ChangeStreamOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;

final class AsyncChangeStreamBatchCursor<T>
implements AsyncBatchCursor<T> {
    private final AsyncReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private volatile BsonDocument resumeToken;
    private volatile AsyncBatchCursor<RawBsonDocument> wrapped;

    AsyncChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AsyncBatchCursor<RawBsonDocument> wrapped, AsyncReadBinding binding) {
        this.changeStreamOperation = changeStreamOperation;
        this.resumeToken = changeStreamOperation.getResumeToken();
        this.wrapped = wrapped;
        this.binding = binding;
        binding.retain();
    }

    AsyncBatchCursor<RawBsonDocument> getWrapped() {
        return this.wrapped;
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resumeableOperation(new AsyncBlock(){

            @Override
            public void apply(AsyncBatchCursor<RawBsonDocument> cursor, SingleResultCallback<List<RawBsonDocument>> callback) {
                cursor.next(callback);
            }
        }, this.convertResultsCallback(callback));
    }

    @Override
    public void tryNext(SingleResultCallback<List<T>> callback) {
        this.resumeableOperation(new AsyncBlock(){

            @Override
            public void apply(AsyncBatchCursor<RawBsonDocument> cursor, SingleResultCallback<List<RawBsonDocument>> callback) {
                cursor.tryNext(callback);
            }
        }, this.convertResultsCallback(callback));
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.binding.release();
    }

    private void resumeableOperation(final AsyncBlock asyncBlock, final SingleResultCallback<List<RawBsonDocument>> callback) {
        asyncBlock.apply(this.wrapped, new SingleResultCallback<List<RawBsonDocument>>(){

            @Override
            public void onResult(List<RawBsonDocument> result, Throwable t) {
                if (t == null) {
                    callback.onResult(result, null);
                } else if (t instanceof MongoNotPrimaryException || t instanceof MongoCursorNotFoundException || t instanceof MongoSocketException) {
                    AsyncChangeStreamBatchCursor.this.wrapped.close();
                    AsyncChangeStreamBatchCursor.this.retryOperation(asyncBlock, callback);
                } else {
                    callback.onResult(null, t);
                }
            }
        });
    }

    private void retryOperation(final AsyncBlock asyncBlock, final SingleResultCallback<List<RawBsonDocument>> callback) {
        this.changeStreamOperation.resumeAfter(this.resumeToken).executeAsync(this.binding, new SingleResultCallback<AsyncBatchCursor<T>>(){

            @Override
            public void onResult(AsyncBatchCursor<T> result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    AsyncChangeStreamBatchCursor.this.wrapped = ((AsyncChangeStreamBatchCursor)result).getWrapped();
                    asyncBlock.apply(AsyncChangeStreamBatchCursor.this.wrapped, callback);
                }
            }
        });
    }

    private SingleResultCallback<List<RawBsonDocument>> convertResultsCallback(final SingleResultCallback<List<T>> callback) {
        return ErrorHandlingResultCallback.errorHandlingCallback(new SingleResultCallback<List<RawBsonDocument>>(){

            @Override
            public void onResult(List<RawBsonDocument> rawDocuments, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (rawDocuments != null) {
                    ArrayList results = new ArrayList();
                    for (RawBsonDocument rawDocument : rawDocuments) {
                        if (!rawDocument.containsKey("_id")) {
                            callback.onResult(null, new MongoChangeStreamException("Cannot provide resume functionality when the resume token is missing."));
                            return;
                        }
                        AsyncChangeStreamBatchCursor.this.resumeToken = rawDocument.getDocument("_id");
                        results.add(rawDocument.decode(AsyncChangeStreamBatchCursor.this.changeStreamOperation.getDecoder()));
                    }
                    callback.onResult(results, null);
                } else {
                    callback.onResult(null, null);
                }
            }
        }, OperationHelper.LOGGER);
    }

    private static interface AsyncBlock {
        public void apply(AsyncBatchCursor<RawBsonDocument> var1, SingleResultCallback<List<RawBsonDocument>> var2);
    }
}

