/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.internal.session;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonArray;
import me.lucko.helper.mongo.external.bson.BsonBinary;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonDocumentWriter;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.UuidRepresentation;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.UuidCodec;
import me.lucko.helper.mongo.external.mongodriver.MongoException;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.connection.Cluster;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.internal.connection.ConcurrentPool;
import me.lucko.helper.mongo.external.mongodriver.internal.connection.NoOpSessionContext;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.selector.ReadPreferenceServerSelector;
import me.lucko.helper.mongo.external.mongodriver.session.ServerSession;

public class ServerSessionPool {
    private static final int END_SESSIONS_BATCH_SIZE = 10000;
    private final ConcurrentPool<ServerSessionImpl> serverSessionPool = new ConcurrentPool<ServerSessionImpl>(Integer.MAX_VALUE, new ServerSessionItemFactory());
    private final Cluster cluster;
    private final Clock clock;
    private volatile boolean closing;
    private volatile boolean closed;
    private final List<BsonDocument> closedSessionIdentifiers = new ArrayList<BsonDocument>();

    public ServerSessionPool(Cluster cluster) {
        this(cluster, new Clock(){

            @Override
            public long millis() {
                return System.currentTimeMillis();
            }
        });
    }

    public ServerSessionPool(Cluster cluster, Clock clock) {
        this.cluster = cluster;
        this.clock = clock;
    }

    public ServerSession get() {
        Assertions.isTrue("server session pool is open", !this.closed);
        ServerSessionImpl serverSession = this.serverSessionPool.get();
        while (this.shouldPrune(serverSession)) {
            this.serverSessionPool.release(serverSession, true);
            serverSession = this.serverSessionPool.get();
        }
        return serverSession;
    }

    public void release(ServerSession serverSession) {
        this.serverSessionPool.release((ServerSessionImpl)serverSession);
        this.serverSessionPool.prune();
    }

    public void close() {
        try {
            this.closing = true;
            this.serverSessionPool.close();
            this.endClosedSessions();
        }
        finally {
            this.closed = true;
        }
    }

    private void closeSession(ServerSessionImpl serverSession) {
        serverSession.close();
        if (!this.closing) {
            return;
        }
        this.closedSessionIdentifiers.add(serverSession.getIdentifier());
        if (this.closedSessionIdentifiers.size() == 10000) {
            this.endClosedSessions();
        }
    }

    private void endClosedSessions() {
        if (this.closedSessionIdentifiers.isEmpty()) {
            return;
        }
        Connection connection = this.cluster.selectServer(new ReadPreferenceServerSelector(ReadPreference.primaryPreferred())).getConnection();
        try {
            connection.command("admin", new BsonDocument("endSessions", new BsonArray(this.closedSessionIdentifiers)), new NoOpFieldNameValidator(), ReadPreference.primaryPreferred(), new BsonDocumentCodec(), NoOpSessionContext.INSTANCE);
        }
        catch (MongoException mongoException) {
        }
        finally {
            this.closedSessionIdentifiers.clear();
            connection.release();
        }
    }

    private boolean shouldPrune(ServerSessionImpl serverSession) {
        long oneMinuteFromTimeout;
        Integer logicalSessionTimeoutMinutes = this.cluster.getDescription().getLogicalSessionTimeoutMinutes();
        if (logicalSessionTimeoutMinutes == null) {
            return false;
        }
        long currentTimeMillis = this.clock.millis();
        long timeSinceLastUse = currentTimeMillis - serverSession.getLastUsedAtMillis();
        return timeSinceLastUse > (oneMinuteFromTimeout = TimeUnit.MINUTES.toMillis(logicalSessionTimeoutMinutes - 1));
    }

    private final class ServerSessionItemFactory
    implements ConcurrentPool.ItemFactory<ServerSessionImpl> {
        private ServerSessionItemFactory() {
        }

        @Override
        public ServerSessionImpl create(boolean initialize) {
            return new ServerSessionImpl(this.createNewServerSessionIdentifier());
        }

        @Override
        public void close(ServerSessionImpl serverSession) {
            ServerSessionPool.this.closeSession(serverSession);
        }

        @Override
        public ConcurrentPool.Prune shouldPrune(ServerSessionImpl serverSession) {
            return ServerSessionPool.this.shouldPrune(serverSession) ? ConcurrentPool.Prune.YES : ConcurrentPool.Prune.STOP;
        }

        private BsonBinary createNewServerSessionIdentifier() {
            UuidCodec uuidCodec = new UuidCodec(UuidRepresentation.STANDARD);
            BsonDocument holder = new BsonDocument();
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(holder);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName("id");
            uuidCodec.encode((BsonWriter)bsonDocumentWriter, UUID.randomUUID(), EncoderContext.builder().build());
            bsonDocumentWriter.writeEndDocument();
            return holder.getBinary("id");
        }
    }

    final class ServerSessionImpl
    implements ServerSession {
        private final BsonDocument identifier;
        private int transactionNumber;
        private volatile long lastUsedAtMillis;
        private volatile boolean closed;

        ServerSessionImpl(BsonBinary identifier) {
            this.lastUsedAtMillis = ServerSessionPool.this.clock.millis();
            this.identifier = new BsonDocument("id", identifier);
        }

        void close() {
            this.closed = true;
        }

        long getLastUsedAtMillis() {
            return this.lastUsedAtMillis;
        }

        int getTransactionNumber() {
            return this.transactionNumber;
        }

        @Override
        public BsonDocument getIdentifier() {
            this.lastUsedAtMillis = ServerSessionPool.this.clock.millis();
            return this.identifier;
        }

        @Override
        public long advanceTransactionNumber() {
            return this.transactionNumber++;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }
    }

    static interface Clock {
        public long millis();
    }
}

