/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.internal.session;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonTimestamp;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.session.ClientSession;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

public class ClientSessionContext
implements SessionContext {
    private ClientSession clientSession;

    public ClientSessionContext(ClientSession clientSession) {
        this.clientSession = Assertions.notNull("clientSession", clientSession);
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public boolean hasSession() {
        return true;
    }

    @Override
    public BsonDocument getSessionId() {
        return this.clientSession.getServerSession().getIdentifier();
    }

    @Override
    public boolean isCausallyConsistent() {
        return this.clientSession.isCausallyConsistent();
    }

    @Override
    public long advanceTransactionNumber() {
        return this.clientSession.getServerSession().advanceTransactionNumber();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.clientSession.getOperationTime();
    }

    @Override
    public void advanceOperationTime(BsonTimestamp operationTime) {
        this.clientSession.advanceOperationTime(operationTime);
    }

    @Override
    public BsonDocument getClusterTime() {
        return this.clientSession.getClusterTime();
    }

    @Override
    public void advanceClusterTime(BsonDocument clusterTime) {
        this.clientSession.advanceClusterTime(clusterTime);
    }
}

