/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.internal.event;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionPoolSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerSettings;
import me.lucko.helper.mongo.external.mongodriver.event.ClusterListener;
import me.lucko.helper.mongo.external.mongodriver.event.ClusterListenerAdapter;
import me.lucko.helper.mongo.external.mongodriver.event.CommandListener;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionPoolListener;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionPoolListenerAdapter;
import me.lucko.helper.mongo.external.mongodriver.event.ServerListener;
import me.lucko.helper.mongo.external.mongodriver.event.ServerListenerAdapter;
import me.lucko.helper.mongo.external.mongodriver.event.ServerMonitorListener;
import me.lucko.helper.mongo.external.mongodriver.event.ServerMonitorListenerAdapter;
import me.lucko.helper.mongo.external.mongodriver.internal.event.ClusterListenerMulticaster;
import me.lucko.helper.mongo.external.mongodriver.internal.event.CommandListenerMulticaster;
import me.lucko.helper.mongo.external.mongodriver.internal.event.ConnectionPoolListenerMulticaster;
import me.lucko.helper.mongo.external.mongodriver.internal.event.ServerListenerMulticaster;
import me.lucko.helper.mongo.external.mongodriver.internal.event.ServerMonitorListenerMulticaster;

public final class EventListenerHelper {
    public static final ServerListener NO_OP_SERVER_LISTENER = new ServerListenerAdapter(){};
    public static final ServerMonitorListener NO_OP_SERVER_MONITOR_LISTENER = new ServerMonitorListenerAdapter(){};
    public static final ClusterListener NO_OP_CLUSTER_LISTENER = new ClusterListenerAdapter(){};
    public static final ConnectionPoolListener NO_OP_CONNECTION_POOL_LISTENER = new ConnectionPoolListenerAdapter(){};

    public static ClusterListener getClusterListener(ClusterSettings clusterSettings) {
        switch (clusterSettings.getClusterListeners().size()) {
            case 0: {
                return NO_OP_CLUSTER_LISTENER;
            }
            case 1: {
                return clusterSettings.getClusterListeners().get(0);
            }
        }
        return new ClusterListenerMulticaster(clusterSettings.getClusterListeners());
    }

    public static CommandListener getCommandListener(List<CommandListener> commandListeners) {
        switch (commandListeners.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return commandListeners.get(0);
            }
        }
        return new CommandListenerMulticaster(commandListeners);
    }

    public static ConnectionPoolListener getConnectionPoolListener(ConnectionPoolSettings connectionPoolSettings) {
        switch (connectionPoolSettings.getConnectionPoolListeners().size()) {
            case 0: {
                return NO_OP_CONNECTION_POOL_LISTENER;
            }
            case 1: {
                return connectionPoolSettings.getConnectionPoolListeners().get(0);
            }
        }
        return new ConnectionPoolListenerMulticaster(connectionPoolSettings.getConnectionPoolListeners());
    }

    public static ServerMonitorListener getServerMonitorListener(ServerSettings serverSettings) {
        switch (serverSettings.getServerMonitorListeners().size()) {
            case 0: {
                return NO_OP_SERVER_MONITOR_LISTENER;
            }
            case 1: {
                return serverSettings.getServerMonitorListeners().get(0);
            }
        }
        return new ServerMonitorListenerMulticaster(serverSettings.getServerMonitorListeners());
    }

    public static ServerListener createServerListener(ServerSettings serverSettings, ServerListener additionalServerListener) {
        ArrayList<ServerListener> mergedServerListeners = new ArrayList<ServerListener>();
        if (additionalServerListener != null) {
            mergedServerListeners.add(additionalServerListener);
        }
        mergedServerListeners.addAll(serverSettings.getServerListeners());
        switch (mergedServerListeners.size()) {
            case 0: {
                return NO_OP_SERVER_LISTENER;
            }
            case 1: {
                return (ServerListener)mergedServerListeners.get(0);
            }
        }
        return new ServerListenerMulticaster(mergedServerListeners);
    }

    private EventListenerHelper() {
    }
}

