/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.internal.event;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Logger;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Loggers;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionAddedEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionCheckedInEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionCheckedOutEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionPoolClosedEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionPoolListener;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionPoolOpenedEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionPoolWaitQueueEnteredEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionPoolWaitQueueExitedEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionRemovedEvent;

final class ConnectionPoolListenerMulticaster
implements ConnectionPoolListener {
    private static final Logger LOGGER = Loggers.getLogger("protocol.event");
    private final List<ConnectionPoolListener> connectionPoolListeners;

    ConnectionPoolListenerMulticaster(List<ConnectionPoolListener> connectionPoolListeners) {
        Assertions.isTrue("All ConnectionPoolListener instances are non-null", !connectionPoolListeners.contains(null));
        this.connectionPoolListeners = new ArrayList<ConnectionPoolListener>(connectionPoolListeners);
    }

    @Override
    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionPoolOpened(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool opened event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionPoolClosed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool closed event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionCheckedOut(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool checked out event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionCheckedIn(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool checked in event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.waitQueueEntered(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool wait queue entered event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.waitQueueExited(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool wait queue exited event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionAdded(ConnectionAddedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionAdded(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool connection added event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void connectionRemoved(ConnectionRemovedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            try {
                cur.connectionRemoved(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool connection removed event to listener %s", cur), e);
            }
        }
    }
}

