/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.event;

import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionId;

public final class ServerHeartbeatFailedEvent {
    private final ConnectionId connectionId;
    private final long elapsedTimeNanos;
    private final Throwable throwable;

    public ServerHeartbeatFailedEvent(ConnectionId connectionId, long elapsedTimeNanos, Throwable throwable) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
        this.throwable = Assertions.notNull("throwable", throwable);
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "ServerHeartbeatFailedEvent{connectionId=" + this.connectionId + ", elapsedTimeNanos=" + this.elapsedTimeNanos + ", throwable=" + this.throwable + "} " + super.toString();
    }
}

