/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import me.lucko.helper.mongo.external.mongodriver.MongoCompressor;
import me.lucko.helper.mongo.external.mongodriver.connection.Compressor;

class ZlibCompressor
extends Compressor {
    private final int level;

    ZlibCompressor(MongoCompressor mongoCompressor) {
        this.level = mongoCompressor.getProperty("LEVEL", -1);
    }

    @Override
    public String getName() {
        return "zlib";
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    InputStream getInputStream(InputStream source) throws IOException {
        return new InflaterInputStream(source);
    }

    @Override
    OutputStream getOutputStream(OutputStream source) throws IOException {
        return new DeflaterOutputStream(source, new Deflater(this.level));
    }
}

