/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt32;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.mongodriver.AuthenticationMechanism;
import me.lucko.helper.mongo.external.mongodriver.MongoCommandException;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.MongoSecurityException;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.connection.Authenticator;
import me.lucko.helper.mongo.external.mongodriver.connection.CommandHelper;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerVersion;

class X509Authenticator
extends Authenticator {
    X509Authenticator(MongoCredential credential) {
        super(credential);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        try {
            this.validateUserName(connectionDescription);
            BsonDocument authCommand = this.getAuthCommand(this.getCredential().getUserName());
            CommandHelper.executeCommand(this.getCredential().getSource(), authCommand, connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, final SingleResultCallback<Void> callback) {
        try {
            this.validateUserName(connectionDescription);
            CommandHelper.executeCommandAsync(this.getCredential().getSource(), this.getAuthCommand(this.getCredential().getUserName()), connection, new SingleResultCallback<BsonDocument>(){

                @Override
                public void onResult(BsonDocument nonceResult, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, X509Authenticator.this.translateThrowable(t));
                    } else {
                        callback.onResult(null, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    private BsonDocument getAuthCommand(String userName) {
        BsonDocument cmd = new BsonDocument();
        cmd.put("authenticate", new BsonInt32(1));
        if (userName != null) {
            cmd.put("user", new BsonString(userName));
        }
        cmd.put("mechanism", new BsonString(AuthenticationMechanism.MONGODB_X509.getMechanismName()));
        return cmd;
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getCredential(), "Exception authenticating", t);
        }
        return t;
    }

    private void validateUserName(ConnectionDescription connectionDescription) {
        if (this.getCredential().getUserName() == null && connectionDescription.getServerVersion().compareTo(new ServerVersion(3, 4)) < 0) {
            throw new MongoSecurityException(this.getCredential(), "User name is required for the MONGODB-X509 authentication mechanism on server versions less than 3.4");
        }
    }
}

