/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.bulk.UpdateRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.LegacyMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.OpCode;
import me.lucko.helper.mongo.external.mongodriver.connection.RequestMessage;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.CollectibleDocumentFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.UpdateFieldNameValidator;

class UpdateMessage
extends LegacyMessage {
    private final UpdateRequest updateRequest;

    UpdateMessage(String collectionName, UpdateRequest updateRequest, MessageSettings settings) {
        super(collectionName, OpCode.OP_UPDATE, settings);
        this.updateRequest = updateRequest;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(this.getCollectionName());
        int flags = 0;
        if (this.updateRequest.isUpsert()) {
            flags |= 1;
        }
        if (this.updateRequest.isMulti()) {
            flags |= 2;
        }
        bsonOutput.writeInt32(flags);
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(this.updateRequest.getFilter(), bsonOutput, new NoOpFieldNameValidator());
        if (this.updateRequest.getType() == WriteRequest.Type.REPLACE) {
            this.addCollectibleDocument(this.updateRequest.getUpdate(), bsonOutput, new CollectibleDocumentFieldNameValidator());
        } else {
            int bufferPosition = bsonOutput.getPosition();
            this.addDocument(this.updateRequest.getUpdate(), bsonOutput, new UpdateFieldNameValidator());
            if (bsonOutput.getPosition() == bufferPosition + 5) {
                throw new IllegalArgumentException("Invalid BSON document for an update");
            }
        }
        return new RequestMessage.EncodingMetadata(firstDocumentStartPosition);
    }
}

