/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.BsonBinaryWriter;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.connection.BsonWriterHelper;
import me.lucko.helper.mongo.external.mongodriver.connection.LevelCountingBsonWriter;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.SplittablePayload;

class SplittablePayloadBsonWriter
extends LevelCountingBsonWriter {
    private final BsonWriter writer;
    private final BsonOutput bsonOutput;
    private final SplittablePayload payload;
    private final MessageSettings settings;
    private int commandStartPosition;

    SplittablePayloadBsonWriter(BsonBinaryWriter writer, BsonOutput bsonOutput, MessageSettings settings, SplittablePayload payload) {
        super(writer);
        this.writer = writer;
        this.bsonOutput = bsonOutput;
        this.settings = settings;
        this.payload = payload;
    }

    @Override
    public void writeStartDocument() {
        super.writeStartDocument();
        if (this.getCurrentLevel() == 0) {
            this.commandStartPosition = this.bsonOutput.getPosition();
        }
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0 && this.payload.getPayload().size() > 0) {
            BsonWriterHelper.writePayloadArray(this.writer, this.bsonOutput, this.settings, this.commandStartPosition, this.payload);
        }
        super.writeEndDocument();
    }
}

