/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import me.lucko.helper.mongo.external.mongodriver.MongoClientException;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.connection.BufferProvider;
import me.lucko.helper.mongo.external.mongodriver.connection.SocketChannelStream;
import me.lucko.helper.mongo.external.mongodriver.connection.SocketSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.SocketStream;
import me.lucko.helper.mongo.external.mongodriver.connection.SslSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.Stream;
import me.lucko.helper.mongo.external.mongodriver.connection.StreamFactory;
import me.lucko.helper.mongo.external.mongodriver.internal.connection.PowerOfTwoBufferPool;

public class SocketStreamFactory
implements StreamFactory {
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final SocketFactory socketFactory;
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings, SocketFactory socketFactory) {
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.socketFactory = socketFactory;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        Stream stream = this.socketFactory != null ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.socketFactory, this.bufferProvider) : (this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.settings, this.sslSettings, this.getSslContext().getSocketFactory(), this.bufferProvider) : (System.getProperty("org.mongodb.useSocket", "false").equals("true") ? new SocketStream(serverAddress, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider) : new SocketChannelStream(serverAddress, this.settings, this.sslSettings, this.bufferProvider)));
        return stream;
    }

    private SSLContext getSslContext() {
        try {
            return this.sslSettings.getContext() == null ? SSLContext.getDefault() : this.sslSettings.getContext();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
    }
}

