/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.helper.mongo.external.bson.BsonBinaryWriter;
import me.lucko.helper.mongo.external.bson.BsonBinaryWriterSettings;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonElement;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.BsonWriterSettings;
import me.lucko.helper.mongo.external.bson.FieldNameValidator;
import me.lucko.helper.mongo.external.bson.codecs.BsonValueCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.Encoder;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistries;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.connection.ElementExtendingBsonWriter;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.OpCode;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

abstract class RequestMessage {
    static final AtomicInteger REQUEST_ID = new AtomicInteger(1);
    private static final int DOCUMENT_HEADROOM = 16384;
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private final String collectionName;
    private final MessageSettings settings;
    private final int id;
    private final OpCode opCode;
    private EncodingMetadata encodingMetadata;

    public static int getCurrentGlobalId() {
        return REQUEST_ID.get();
    }

    RequestMessage(OpCode opCode, MessageSettings settings) {
        this(null, opCode, settings);
    }

    RequestMessage(OpCode opCode, int requestId, MessageSettings settings) {
        this(null, opCode, requestId, settings);
    }

    RequestMessage(String collectionName, OpCode opCode, MessageSettings settings) {
        this(collectionName, opCode, REQUEST_ID.getAndIncrement(), settings);
    }

    private RequestMessage(String collectionName, OpCode opCode, int requestId, MessageSettings settings) {
        this.collectionName = collectionName;
        this.settings = settings;
        this.id = requestId;
        this.opCode = opCode;
    }

    public int getId() {
        return this.id;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public String getNamespace() {
        return this.getCollectionName();
    }

    public MessageSettings getSettings() {
        return this.settings;
    }

    public void encode(BsonOutput bsonOutput, SessionContext sessionContext) {
        Assertions.notNull("sessionContext", sessionContext);
        int messageStartPosition = bsonOutput.getPosition();
        this.writeMessagePrologue(bsonOutput);
        EncodingMetadata encodingMetadata = this.encodeMessageBodyWithMetadata(bsonOutput, sessionContext);
        this.backpatchMessageLength(messageStartPosition, bsonOutput);
        this.encodingMetadata = encodingMetadata;
    }

    public EncodingMetadata getEncodingMetadata() {
        return this.encodingMetadata;
    }

    protected void writeMessagePrologue(BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.id);
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.opCode.getValue());
    }

    protected abstract EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput var1, SessionContext var2);

    protected void addDocument(BsonDocument document, BsonOutput bsonOutput, FieldNameValidator validator) {
        this.addDocument(document, this.getCodec(document), EncoderContext.builder().build(), bsonOutput, validator, this.settings.getMaxDocumentSize() + 16384, null);
    }

    protected void addDocument(BsonDocument document, BsonOutput bsonOutput, FieldNameValidator validator, List<BsonElement> extraElements) {
        this.addDocument(document, this.getCodec(document), EncoderContext.builder().build(), bsonOutput, validator, this.settings.getMaxDocumentSize() + 16384, extraElements);
    }

    protected void addCollectibleDocument(BsonDocument document, BsonOutput bsonOutput, FieldNameValidator validator) {
        this.addDocument(document, this.getCodec(document), EncoderContext.builder().isEncodingCollectibleDocument(true).build(), bsonOutput, validator, this.settings.getMaxDocumentSize(), null);
    }

    protected void backpatchMessageLength(int startPosition, BsonOutput bsonOutput) {
        int messageLength = bsonOutput.getPosition() - startPosition;
        bsonOutput.writeInt32(bsonOutput.getPosition() - messageLength, messageLength);
    }

    protected String getCollectionName() {
        return this.collectionName;
    }

    Codec<BsonDocument> getCodec(BsonDocument document) {
        return REGISTRY.get(document.getClass());
    }

    private <T> void addDocument(T obj, Encoder<T> encoder, EncoderContext encoderContext, BsonOutput bsonOutput, FieldNameValidator validator, int maxDocumentSize, List<BsonElement> extraElements) {
        BsonBinaryWriter bsonBinaryWriter = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(maxDocumentSize), bsonOutput, validator);
        BsonWriter bsonWriter = extraElements == null ? bsonBinaryWriter : new ElementExtendingBsonWriter(bsonBinaryWriter, extraElements);
        encoder.encode(bsonWriter, obj, encoderContext);
    }

    static class EncodingMetadata {
        private final int firstDocumentPosition;

        EncodingMetadata(int firstDocumentPosition) {
            this.firstDocumentPosition = firstDocumentPosition;
        }

        public int getFirstDocumentPosition() {
            return this.firstDocumentPosition;
        }
    }
}

