/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.connection.BaseQueryMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.RequestMessage;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;

class QueryMessage
extends BaseQueryMessage {
    private final BsonDocument queryDocument;
    private final BsonDocument fields;

    QueryMessage(String collectionName, int skip, int numberToReturn, BsonDocument queryDocument, BsonDocument fields, MessageSettings settings) {
        super(collectionName, skip, numberToReturn, settings);
        this.queryDocument = queryDocument;
        this.fields = fields;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput) {
        this.writeQueryPrologue(bsonOutput);
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(this.queryDocument, bsonOutput, new NoOpFieldNameValidator());
        if (this.fields != null) {
            this.addDocument(this.fields, bsonOutput, new NoOpFieldNameValidator());
        }
        return new RequestMessage.EncodingMetadata(firstDocumentStartPosition);
    }
}

