/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.BsonBinary;
import me.lucko.helper.mongo.external.bson.BsonBinaryWriter;
import me.lucko.helper.mongo.external.bson.BsonDbPointer;
import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonRegularExpression;
import me.lucko.helper.mongo.external.bson.BsonTimestamp;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.assertions.Assertions;
import me.lucko.helper.mongo.external.bson.types.Decimal128;
import me.lucko.helper.mongo.external.bson.types.ObjectId;

abstract class LevelCountingBsonWriter
implements BsonWriter {
    private final BsonBinaryWriter bsonBinaryWriter;
    private int level = -1;

    LevelCountingBsonWriter(BsonBinaryWriter bsonBinaryWriter) {
        this.bsonBinaryWriter = Assertions.notNull("bsonBinaryWriter", bsonBinaryWriter);
    }

    public int getCurrentLevel() {
        return this.level;
    }

    public BsonBinaryWriter getBsonBinaryWriter() {
        return this.bsonBinaryWriter;
    }

    @Override
    public void writeStartDocument(String name) {
        ++this.level;
        this.bsonBinaryWriter.writeStartDocument(name);
    }

    @Override
    public void writeStartDocument() {
        ++this.level;
        this.bsonBinaryWriter.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        --this.level;
        this.bsonBinaryWriter.writeEndDocument();
    }

    @Override
    public void writeStartArray(String name) {
        this.bsonBinaryWriter.writeStartArray(name);
    }

    @Override
    public void writeStartArray() {
        this.bsonBinaryWriter.writeStartArray();
    }

    @Override
    public void writeEndArray() {
        this.bsonBinaryWriter.writeEndArray();
    }

    @Override
    public void writeBinaryData(String name, BsonBinary binary) {
        this.bsonBinaryWriter.writeBinaryData(name, binary);
    }

    @Override
    public void writeBinaryData(BsonBinary binary) {
        this.bsonBinaryWriter.writeBinaryData(binary);
    }

    @Override
    public void writeBoolean(String name, boolean value) {
        this.bsonBinaryWriter.writeBoolean(name, value);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.bsonBinaryWriter.writeBoolean(value);
    }

    @Override
    public void writeDateTime(String name, long value) {
        this.bsonBinaryWriter.writeDateTime(name, value);
    }

    @Override
    public void writeDateTime(long value) {
        this.bsonBinaryWriter.writeDateTime(value);
    }

    @Override
    public void writeDBPointer(String name, BsonDbPointer value) {
        this.bsonBinaryWriter.writeDBPointer(name, value);
    }

    @Override
    public void writeDBPointer(BsonDbPointer value) {
        this.bsonBinaryWriter.writeDBPointer(value);
    }

    @Override
    public void writeDouble(String name, double value) {
        this.bsonBinaryWriter.writeDouble(name, value);
    }

    @Override
    public void writeDouble(double value) {
        this.bsonBinaryWriter.writeDouble(value);
    }

    @Override
    public void writeInt32(String name, int value) {
        this.bsonBinaryWriter.writeInt32(name, value);
    }

    @Override
    public void writeInt32(int value) {
        this.bsonBinaryWriter.writeInt32(value);
    }

    @Override
    public void writeInt64(String name, long value) {
        this.bsonBinaryWriter.writeInt64(name, value);
    }

    @Override
    public void writeInt64(long value) {
        this.bsonBinaryWriter.writeInt64(value);
    }

    @Override
    public void writeDecimal128(Decimal128 value) {
        this.bsonBinaryWriter.writeDecimal128(value);
    }

    @Override
    public void writeDecimal128(String name, Decimal128 value) {
        this.bsonBinaryWriter.writeDecimal128(name, value);
    }

    @Override
    public void writeJavaScript(String name, String code) {
        this.bsonBinaryWriter.writeJavaScript(name, code);
    }

    @Override
    public void writeJavaScript(String code) {
        this.bsonBinaryWriter.writeJavaScript(code);
    }

    @Override
    public void writeJavaScriptWithScope(String name, String code) {
        this.bsonBinaryWriter.writeJavaScriptWithScope(name, code);
    }

    @Override
    public void writeJavaScriptWithScope(String code) {
        this.bsonBinaryWriter.writeJavaScriptWithScope(code);
    }

    @Override
    public void writeMaxKey(String name) {
        this.bsonBinaryWriter.writeMaxKey(name);
    }

    @Override
    public void writeMaxKey() {
        this.bsonBinaryWriter.writeMaxKey();
    }

    @Override
    public void writeMinKey(String name) {
        this.bsonBinaryWriter.writeMinKey(name);
    }

    @Override
    public void writeMinKey() {
        this.bsonBinaryWriter.writeMinKey();
    }

    @Override
    public void writeName(String name) {
        this.bsonBinaryWriter.writeName(name);
    }

    @Override
    public void writeNull(String name) {
        this.bsonBinaryWriter.writeNull(name);
    }

    @Override
    public void writeNull() {
        this.bsonBinaryWriter.writeNull();
    }

    @Override
    public void writeObjectId(String name, ObjectId objectId) {
        this.bsonBinaryWriter.writeObjectId(name, objectId);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        this.bsonBinaryWriter.writeObjectId(objectId);
    }

    @Override
    public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
        this.bsonBinaryWriter.writeRegularExpression(name, regularExpression);
    }

    @Override
    public void writeRegularExpression(BsonRegularExpression regularExpression) {
        this.bsonBinaryWriter.writeRegularExpression(regularExpression);
    }

    @Override
    public void writeString(String name, String value) {
        this.bsonBinaryWriter.writeString(name, value);
    }

    @Override
    public void writeString(String value) {
        this.bsonBinaryWriter.writeString(value);
    }

    @Override
    public void writeSymbol(String name, String value) {
        this.bsonBinaryWriter.writeSymbol(name, value);
    }

    @Override
    public void writeSymbol(String value) {
        this.bsonBinaryWriter.writeSymbol(value);
    }

    @Override
    public void writeTimestamp(String name, BsonTimestamp value) {
        this.bsonBinaryWriter.writeTimestamp(name, value);
    }

    @Override
    public void writeTimestamp(BsonTimestamp value) {
        this.bsonBinaryWriter.writeTimestamp(value);
    }

    @Override
    public void writeUndefined(String name) {
        this.bsonBinaryWriter.writeUndefined(name);
    }

    @Override
    public void writeUndefined() {
        this.bsonBinaryWriter.writeUndefined();
    }

    @Override
    public void pipe(BsonReader reader) {
        this.bsonBinaryWriter.pipe(reader);
    }

    @Override
    public void flush() {
        this.bsonBinaryWriter.flush();
    }
}

