/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import me.lucko.helper.mongo.external.bson.BsonBinaryReader;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt32;
import me.lucko.helper.mongo.external.bson.ByteBuf;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.bson.codecs.RawBsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.io.ByteBufferBsonInput;
import me.lucko.helper.mongo.external.mongodriver.MongoClientException;
import me.lucko.helper.mongo.external.mongodriver.MongoCommandException;
import me.lucko.helper.mongo.external.mongodriver.MongoCompressor;
import me.lucko.helper.mongo.external.mongodriver.MongoException;
import me.lucko.helper.mongo.external.mongodriver.MongoInternalException;
import me.lucko.helper.mongo.external.mongodriver.MongoInterruptedException;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.MongoSocketClosedException;
import me.lucko.helper.mongo.external.mongodriver.MongoSocketReadException;
import me.lucko.helper.mongo.external.mongodriver.MongoSocketReadTimeoutException;
import me.lucko.helper.mongo.external.mongodriver.MongoSocketWriteException;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.annotations.NotThreadSafe;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncCompletionHandler;
import me.lucko.helper.mongo.external.mongodriver.connection.ByteBufferBsonOutput;
import me.lucko.helper.mongo.external.mongodriver.connection.CommandMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.CompressedHeader;
import me.lucko.helper.mongo.external.mongodriver.connection.CompressedMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.Compressor;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionId;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnectionInitializer;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageHeader;
import me.lucko.helper.mongo.external.mongodriver.connection.OpCode;
import me.lucko.helper.mongo.external.mongodriver.connection.ProtocolHelper;
import me.lucko.helper.mongo.external.mongodriver.connection.ReplyHeader;
import me.lucko.helper.mongo.external.mongodriver.connection.ReplyMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.ResponseBuffers;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerId;
import me.lucko.helper.mongo.external.mongodriver.connection.SnappyCompressor;
import me.lucko.helper.mongo.external.mongodriver.connection.Stream;
import me.lucko.helper.mongo.external.mongodriver.connection.StreamFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.ZlibCompressor;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Logger;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Loggers;
import me.lucko.helper.mongo.external.mongodriver.event.CommandListener;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

@NotThreadSafe
class InternalStreamConnection
implements InternalConnection {
    private static final Set<String> SECURITY_SENSITIVE_COMMANDS = new HashSet<String>(Arrays.asList("authenticate", "saslStart", "saslContinue", "getnonce", "createUser", "updateUser", "copydbgetnonce", "copydbsaslstart", "copydb"));
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final ServerId serverId;
    private final StreamFactory streamFactory;
    private final InternalConnectionInitializer connectionInitializer;
    private volatile ConnectionDescription description;
    private volatile Stream stream;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicBoolean opened = new AtomicBoolean();
    private final List<MongoCompressor> compressorList;
    private final CommandListener commandListener;
    private volatile Compressor sendCompressor;
    private volatile Map<Byte, Compressor> compressorMap;

    InternalStreamConnection(ServerId serverId, StreamFactory streamFactory, List<MongoCompressor> compressorList, CommandListener commandListener, InternalConnectionInitializer connectionInitializer) {
        this.serverId = Assertions.notNull("serverId", serverId);
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.compressorMap = this.createCompressorMap(compressorList);
        this.commandListener = commandListener;
        this.connectionInitializer = Assertions.notNull("connectionInitializer", connectionInitializer);
        this.description = new ConnectionDescription(serverId);
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.description;
    }

    @Override
    public void open() {
        Assertions.isTrue("Open already called", this.stream == null);
        this.stream = this.streamFactory.create(this.serverId.getAddress());
        try {
            this.stream.open();
            this.description = this.connectionInitializer.initialize(this);
            this.opened.set(true);
            this.sendCompressor = this.findSendCompressor(this.description);
            LOGGER.info(String.format("Opened connection [%s] to %s", this.getId(), this.serverId.getAddress()));
        }
        catch (Throwable t) {
            this.close();
            if (t instanceof MongoException) {
                throw (MongoException)t;
            }
            throw new MongoException(t.toString(), t);
        }
    }

    @Override
    public void openAsync(final SingleResultCallback<Void> callback) {
        Assertions.isTrue("Open already called", this.stream == null, callback);
        try {
            this.stream = this.streamFactory.create(this.serverId.getAddress());
        }
        catch (Throwable t) {
            callback.onResult(null, t);
            return;
        }
        this.stream.openAsync(new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(Void aVoid) {
                InternalStreamConnection.this.connectionInitializer.initializeAsync(InternalStreamConnection.this, new SingleResultCallback<ConnectionDescription>(){

                    @Override
                    public void onResult(ConnectionDescription result, Throwable t) {
                        if (t != null) {
                            InternalStreamConnection.this.close();
                            callback.onResult(null, t);
                        } else {
                            InternalStreamConnection.this.description = result;
                            InternalStreamConnection.this.opened.set(true);
                            InternalStreamConnection.this.sendCompressor = InternalStreamConnection.this.findSendCompressor(InternalStreamConnection.this.description);
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info(String.format("Opened connection [%s] to %s", InternalStreamConnection.this.getId(), InternalStreamConnection.this.serverId.getAddress()));
                            }
                            callback.onResult(null, null);
                        }
                    }
                });
            }

            @Override
            public void failed(Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    private Map<Byte, Compressor> createCompressorMap(List<MongoCompressor> compressorList) {
        HashMap<Byte, Compressor> compressorMap = new HashMap<Byte, Compressor>(this.compressorList.size());
        for (MongoCompressor mongoCompressor : compressorList) {
            Compressor compressor = this.createCompressor(mongoCompressor);
            compressorMap.put(compressor.getId(), compressor);
        }
        return compressorMap;
    }

    private Compressor findSendCompressor(ConnectionDescription description) {
        if (description.getCompressors().isEmpty()) {
            return null;
        }
        String firstCompressorName = description.getCompressors().get(0);
        for (Compressor compressor : this.compressorMap.values()) {
            if (!compressor.getName().equals(firstCompressorName)) continue;
            return compressor;
        }
        throw new MongoInternalException("Unexpected compressor negotiated: " + firstCompressorName);
    }

    private Compressor createCompressor(MongoCompressor mongoCompressor) {
        if (mongoCompressor.getName().equals("zlib")) {
            return new ZlibCompressor(mongoCompressor);
        }
        if (mongoCompressor.getName().equals("snappy")) {
            return new SnappyCompressor();
        }
        throw new MongoClientException("Unsupported compressor " + mongoCompressor.getName());
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Closing connection %s", this.getId()));
            }
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    @Override
    public boolean opened() {
        return this.opened.get();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public <T> T sendAndReceive(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(this);
        LazyCommandDocument lazyCommandDocument = new LazyCommandDocument(message, bsonOutput);
        CommandEventSender commandEventSender = new CommandEventSender(message, lazyCommandDocument);
        try {
            message.encode(bsonOutput, sessionContext);
            commandEventSender.sendStartedEvent();
        }
        catch (RuntimeException e) {
            bsonOutput.close();
            throw e;
        }
        try {
            this.sendCommandMessage(message, lazyCommandDocument, bsonOutput, sessionContext);
            if (message.isResponseExpected()) {
                return this.receiveCommandMessageResponse(message, decoder, commandEventSender, sessionContext);
            }
            commandEventSender.sendSucceededEventForOneWayCommand();
            return null;
        }
        catch (RuntimeException e) {
            commandEventSender.sendFailedEvent(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommandMessage(CommandMessage message, LazyCommandDocument lazyCommandDocument, ByteBufferBsonOutput bsonOutput, SessionContext sessionContext) {
        block7: {
            try {
                if (this.sendCompressor == null || SECURITY_SENSITIVE_COMMANDS.contains(lazyCommandDocument.getName())) {
                    this.sendMessage(bsonOutput.getByteBuffers(), message.getId());
                    break block7;
                }
                CompressedMessage compressedMessage = new CompressedMessage(message.getOpCode(), bsonOutput.getByteBuffers(), this.sendCompressor, ProtocolHelper.getMessageSettings(this.description));
                ByteBufferBsonOutput compressedBsonOutput = new ByteBufferBsonOutput(this);
                compressedMessage.encode(compressedBsonOutput, sessionContext);
                try {
                    this.sendMessage(compressedBsonOutput.getByteBuffers(), message.getId());
                }
                finally {
                    compressedBsonOutput.close();
                }
            }
            finally {
                bsonOutput.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T receiveCommandMessageResponse(CommandMessage message, Decoder<T> decoder, CommandEventSender commandEventSender, SessionContext sessionContext) {
        ResponseBuffers responseBuffers = this.receiveMessage(message.getId());
        try {
            this.updateSessionContext(sessionContext, responseBuffers);
            if (!ProtocolHelper.isCommandOk(responseBuffers)) {
                throw ProtocolHelper.getCommandFailureException(InternalStreamConnection.getResponseDocument(responseBuffers, message.getId(), new BsonDocumentCodec()), this.description.getServerAddress());
            }
            commandEventSender.sendSucceededEvent(responseBuffers);
            T t = new ReplyMessage<T>(responseBuffers, decoder, message.getId()).getDocuments().get(0);
            return t;
        }
        finally {
            responseBuffers.close();
        }
    }

    @Override
    public <T> void sendAndReceiveAsync(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext, SingleResultCallback<T> callback) {
        Assertions.notNull("stream is open", this.stream, callback);
        if (this.isClosed()) {
            callback.onResult(null, new MongoSocketClosedException("Can not read from a closed socket", this.getServerAddress()));
            return;
        }
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(this);
        ByteBufferBsonOutput compressedBsonOutput = new ByteBufferBsonOutput(this);
        try {
            message.encode(bsonOutput, sessionContext);
            LazyCommandDocument lazyCommandDocument = new LazyCommandDocument(message, bsonOutput);
            CommandEventSender commandEventSender = new CommandEventSender(message, lazyCommandDocument);
            commandEventSender.sendStartedEvent();
            if (this.sendCompressor == null || SECURITY_SENSITIVE_COMMANDS.contains(lazyCommandDocument.getName())) {
                this.sendCommandMessageAsync(message.getId(), decoder, sessionContext, callback, bsonOutput, commandEventSender, message.isResponseExpected());
            } else {
                CompressedMessage compressedMessage = new CompressedMessage(message.getOpCode(), bsonOutput.getByteBuffers(), this.sendCompressor, ProtocolHelper.getMessageSettings(this.description));
                compressedMessage.encode(compressedBsonOutput, sessionContext);
                bsonOutput.close();
                this.sendCommandMessageAsync(message.getId(), decoder, sessionContext, callback, compressedBsonOutput, commandEventSender, message.isResponseExpected());
            }
        }
        catch (Throwable t) {
            bsonOutput.close();
            compressedBsonOutput.close();
            callback.onResult(null, t);
        }
    }

    private <T> void sendCommandMessageAsync(final int messageId, final Decoder<T> decoder, final SessionContext sessionContext, final SingleResultCallback<T> callback, final ByteBufferBsonOutput bsonOutput, final CommandEventSender commandEventSender, final boolean responseExpected) {
        this.sendMessageAsync(bsonOutput.getByteBuffers(), messageId, new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                bsonOutput.close();
                if (t != null) {
                    commandEventSender.sendFailedEvent(t);
                    callback.onResult(null, t);
                } else if (!responseExpected) {
                    commandEventSender.sendSucceededEventForOneWayCommand();
                    callback.onResult(null, null);
                } else {
                    InternalStreamConnection.this.readAsync(16, new MessageHeaderCallback(new SingleResultCallback<ResponseBuffers>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onResult(ResponseBuffers responseBuffers, Throwable t) {
                            if (t != null) {
                                commandEventSender.sendFailedEvent(t);
                                callback.onResult(null, t);
                                return;
                            }
                            try {
                                InternalStreamConnection.this.updateSessionContext(sessionContext, responseBuffers);
                                boolean commandOk = ProtocolHelper.isCommandOk(new BsonBinaryReader(new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer())));
                                responseBuffers.reset();
                                if (!commandOk) {
                                    MongoException commandFailureException = ProtocolHelper.getCommandFailureException(InternalStreamConnection.getResponseDocument(responseBuffers, messageId, new BsonDocumentCodec()), InternalStreamConnection.this.description.getServerAddress());
                                    commandEventSender.sendFailedEvent(commandFailureException);
                                    throw commandFailureException;
                                }
                                commandEventSender.sendSucceededEvent(responseBuffers);
                                Object result = new ReplyMessage(responseBuffers, decoder, messageId).getDocuments().get(0);
                                callback.onResult(result, null);
                            }
                            catch (Throwable localThrowable) {
                                callback.onResult(null, localThrowable);
                            }
                            finally {
                                responseBuffers.close();
                            }
                        }
                    }));
                }
            }
        });
    }

    @Override
    public void sendMessage(List<ByteBuf> byteBuffers, int lastRequestId) {
        Assertions.notNull("stream is open", this.stream);
        if (this.isClosed()) {
            throw new MongoSocketClosedException("Cannot write to a closed stream", this.getServerAddress());
        }
        try {
            this.stream.write(byteBuffers);
        }
        catch (Exception e) {
            this.close();
            throw this.translateWriteException(e);
        }
    }

    @Override
    public ResponseBuffers receiveMessage(int responseTo) {
        Assertions.notNull("stream is open", this.stream);
        if (this.isClosed()) {
            throw new MongoSocketClosedException("Cannot read from a closed stream", this.getServerAddress());
        }
        try {
            return this.receiveResponseBuffers();
        }
        catch (Throwable t) {
            this.close();
            throw this.translateReadException(t);
        }
    }

    @Override
    public void sendMessageAsync(List<ByteBuf> byteBuffers, int lastRequestId, SingleResultCallback<Void> callback) {
        Assertions.notNull("stream is open", this.stream, callback);
        if (this.isClosed()) {
            callback.onResult(null, new MongoSocketClosedException("Can not read from a closed socket", this.getServerAddress()));
            return;
        }
        this.writeAsync(byteBuffers, ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER));
    }

    private void writeAsync(List<ByteBuf> byteBuffers, final SingleResultCallback<Void> callback) {
        this.stream.writeAsync(byteBuffers, new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(Void v) {
                callback.onResult(null, null);
            }

            @Override
            public void failed(Throwable t) {
                InternalStreamConnection.this.close();
                callback.onResult(null, InternalStreamConnection.this.translateWriteException(t));
            }
        });
    }

    @Override
    public void receiveMessageAsync(int responseTo, final SingleResultCallback<ResponseBuffers> callback) {
        Assertions.isTrue("stream is open", this.stream != null, callback);
        if (this.isClosed()) {
            callback.onResult(null, new MongoSocketClosedException("Can not read from a closed socket", this.getServerAddress()));
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Start receiving response on %s", this.getId()));
        }
        this.readAsync(16, new MessageHeaderCallback(new SingleResultCallback<ResponseBuffers>(){

            @Override
            public void onResult(ResponseBuffers result, Throwable t) {
                if (t != null) {
                    InternalStreamConnection.this.close();
                    callback.onResult(null, t);
                } else {
                    callback.onResult(result, null);
                }
            }
        }));
    }

    private void readAsync(int numBytes, final SingleResultCallback<ByteBuf> callback) {
        if (this.isClosed()) {
            callback.onResult(null, new MongoSocketClosedException("Cannot read from a closed stream", this.getServerAddress()));
            return;
        }
        try {
            this.stream.readAsync(numBytes, new AsyncCompletionHandler<ByteBuf>(){

                @Override
                public void completed(ByteBuf buffer) {
                    callback.onResult(buffer, null);
                }

                @Override
                public void failed(Throwable t) {
                    InternalStreamConnection.this.close();
                    callback.onResult(null, InternalStreamConnection.this.translateReadException(t));
                }
            });
        }
        catch (Exception e) {
            callback.onResult(null, this.translateReadException(e));
        }
    }

    private ConnectionId getId() {
        return this.description.getConnectionId();
    }

    private ServerAddress getServerAddress() {
        return this.description.getServerAddress();
    }

    private void updateSessionContext(SessionContext sessionContext, ResponseBuffers responseBuffers) {
        sessionContext.advanceOperationTime(ProtocolHelper.getOperationTime(responseBuffers));
        sessionContext.advanceClusterTime(ProtocolHelper.getClusterTime(responseBuffers));
    }

    private MongoException translateWriteException(Throwable e) {
        if (e instanceof MongoException) {
            return (MongoException)e;
        }
        if (e instanceof IOException) {
            return new MongoSocketWriteException("Exception sending message", this.getServerAddress(), e);
        }
        if (e instanceof InterruptedException) {
            return new MongoInternalException("Thread interrupted exception", e);
        }
        return new MongoInternalException("Unexpected exception", e);
    }

    private MongoException translateReadException(Throwable e) {
        if (e instanceof MongoException) {
            return (MongoException)e;
        }
        if (e instanceof SocketTimeoutException) {
            return new MongoSocketReadTimeoutException("Timeout while receiving message", this.getServerAddress(), e);
        }
        if (e instanceof InterruptedIOException) {
            return new MongoInterruptedException("Interrupted while receiving message", (InterruptedIOException)e);
        }
        if (e instanceof ClosedByInterruptException) {
            return new MongoInterruptedException("Interrupted while receiving message", (ClosedByInterruptException)e);
        }
        if (e instanceof IOException) {
            return new MongoSocketReadException("Exception receiving message", this.getServerAddress(), e);
        }
        if (e instanceof RuntimeException) {
            return new MongoInternalException("Unexpected runtime exception", e);
        }
        if (e instanceof InterruptedException) {
            return new MongoInternalException("Interrupted exception", e);
        }
        return new MongoInternalException("Unexpected exception", e);
    }

    private ResponseBuffers receiveResponseBuffers() throws IOException {
        MessageHeader messageHeader;
        ByteBuf messageHeaderBuffer = this.stream.read(16);
        try {
            messageHeader = new MessageHeader(messageHeaderBuffer, this.description.getMaxMessageSize());
        }
        finally {
            messageHeaderBuffer.release();
        }
        ByteBuf messageBuffer = this.stream.read(messageHeader.getMessageLength() - 16);
        if (messageHeader.getOpCode() == OpCode.OP_COMPRESSED.getValue()) {
            CompressedHeader compressedHeader = new CompressedHeader(messageBuffer, messageHeader);
            Compressor compressor = this.getCompressor(compressedHeader);
            ByteBuf buffer = this.getBuffer(compressedHeader.getUncompressedSize());
            compressor.uncompress(messageBuffer, buffer);
            buffer.flip();
            return new ResponseBuffers(new ReplyHeader(buffer, compressedHeader), buffer);
        }
        return new ResponseBuffers(new ReplyHeader(messageBuffer, messageHeader), messageBuffer);
    }

    private Compressor getCompressor(CompressedHeader compressedHeader) {
        Compressor compressor = this.compressorMap.get(compressedHeader.getCompressorId());
        if (compressor == null) {
            throw new MongoClientException("Unsupported compressor with identifier " + compressedHeader.getCompressorId());
        }
        return compressor;
    }

    @Override
    public ByteBuf getBuffer(int size) {
        Assertions.notNull("open", this.stream);
        return this.stream.getBuffer(size);
    }

    private static <T extends BsonDocument> T getResponseDocument(ResponseBuffers responseBuffers, int messageId, Decoder<T> decoder) {
        ReplyMessage<T> replyMessage = new ReplyMessage<T>(responseBuffers, decoder, messageId);
        responseBuffers.reset();
        return (T)((BsonDocument)replyMessage.getDocuments().get(0));
    }

    private static final class LazyCommandDocument {
        private final CommandMessage commandMessage;
        private final ByteBufferBsonOutput bsonOutput;
        private BsonDocument commandDocument;
        private String commandName;

        private LazyCommandDocument(CommandMessage commandMessage, ByteBufferBsonOutput bsonOutput) {
            this.commandMessage = commandMessage;
            this.bsonOutput = bsonOutput;
        }

        public String getName() {
            if (this.commandName == null) {
                this.commandName = this.getDocument().getFirstKey();
            }
            return this.commandName;
        }

        private BsonDocument getDocument() {
            if (this.commandDocument == null) {
                this.commandDocument = this.commandMessage.getCommandDocument(this.bsonOutput);
            }
            return this.commandDocument;
        }
    }

    private class CommandEventSender {
        private final long startTimeNanos = System.nanoTime();
        private final CommandMessage message;
        private final LazyCommandDocument lazyCommandDocument;

        CommandEventSender(CommandMessage message, LazyCommandDocument lazyCommandDocument) {
            this.message = message;
            this.lazyCommandDocument = lazyCommandDocument;
        }

        public void sendStartedEvent() {
            if (InternalStreamConnection.this.commandListener != null && InternalStreamConnection.this.opened()) {
                BsonDocument commandDocumentForEvent = SECURITY_SENSITIVE_COMMANDS.contains(this.lazyCommandDocument.getName()) ? new BsonDocument() : this.lazyCommandDocument.getDocument();
                ProtocolHelper.sendCommandStartedEvent(this.message, new MongoNamespace(this.message.getCollectionName()).getDatabaseName(), this.lazyCommandDocument.getName(), commandDocumentForEvent, InternalStreamConnection.this.getDescription(), InternalStreamConnection.this.commandListener);
            }
        }

        public void sendFailedEvent(Throwable t) {
            if (InternalStreamConnection.this.commandListener != null && InternalStreamConnection.this.opened()) {
                Throwable commandEventException = t;
                if (t instanceof MongoCommandException && SECURITY_SENSITIVE_COMMANDS.contains(this.lazyCommandDocument.getName())) {
                    commandEventException = new MongoCommandException(new BsonDocument(), InternalStreamConnection.this.description.getServerAddress());
                }
                ProtocolHelper.sendCommandFailedEvent(this.message, this.lazyCommandDocument.getName(), InternalStreamConnection.this.description, this.startTimeNanos, commandEventException, InternalStreamConnection.this.commandListener);
            }
        }

        public void sendSucceededEvent(ResponseBuffers responseBuffers) {
            if (InternalStreamConnection.this.commandListener != null && InternalStreamConnection.this.opened()) {
                BsonDocument responseDocumentForEvent = SECURITY_SENSITIVE_COMMANDS.contains(this.lazyCommandDocument.getName()) ? new BsonDocument() : InternalStreamConnection.getResponseDocument(responseBuffers, this.message.getId(), new RawBsonDocumentCodec());
                ProtocolHelper.sendCommandSucceededEvent(this.message, this.lazyCommandDocument.getName(), responseDocumentForEvent, InternalStreamConnection.this.description, this.startTimeNanos, InternalStreamConnection.this.commandListener);
            }
        }

        public void sendSucceededEventForOneWayCommand() {
            if (InternalStreamConnection.this.commandListener != null && InternalStreamConnection.this.opened()) {
                BsonDocument responseDocumentForEvent = new BsonDocument("ok", new BsonInt32(1));
                ProtocolHelper.sendCommandSucceededEvent(this.message, this.lazyCommandDocument.getName(), responseDocumentForEvent, InternalStreamConnection.this.description, this.startTimeNanos, InternalStreamConnection.this.commandListener);
            }
        }
    }

    private class MessageHeaderCallback
    implements SingleResultCallback<ByteBuf> {
        private final SingleResultCallback<ResponseBuffers> callback;

        MessageHeaderCallback(SingleResultCallback<ResponseBuffers> callback) {
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(ByteBuf result, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
                return;
            }
            try {
                MessageHeader messageHeader = new MessageHeader(result, InternalStreamConnection.this.description.getMaxMessageSize());
                InternalStreamConnection.this.readAsync(messageHeader.getMessageLength() - 16, new MessageCallback(messageHeader));
            }
            catch (Throwable localThrowable) {
                this.callback.onResult(null, localThrowable);
            }
            finally {
                if (result != null) {
                    result.release();
                }
            }
        }

        private class MessageCallback
        implements SingleResultCallback<ByteBuf> {
            private final MessageHeader messageHeader;

            MessageCallback(MessageHeader messageHeader) {
                this.messageHeader = messageHeader;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(ByteBuf result, Throwable t) {
                if (t != null) {
                    MessageHeaderCallback.this.callback.onResult(null, t);
                    return;
                }
                try {
                    ByteBuf responseBuffer;
                    ReplyHeader replyHeader;
                    if (this.messageHeader.getOpCode() == OpCode.OP_COMPRESSED.getValue()) {
                        try {
                            CompressedHeader compressedHeader = new CompressedHeader(result, this.messageHeader);
                            Compressor compressor = InternalStreamConnection.this.getCompressor(compressedHeader);
                            ByteBuf buffer = InternalStreamConnection.this.getBuffer(compressedHeader.getUncompressedSize());
                            compressor.uncompress(result, buffer);
                            buffer.flip();
                            replyHeader = new ReplyHeader(buffer, compressedHeader);
                            responseBuffer = buffer;
                        }
                        finally {
                            result.release();
                        }
                    } else {
                        replyHeader = new ReplyHeader(result, this.messageHeader);
                        responseBuffer = result;
                    }
                    MessageHeaderCallback.this.callback.onResult(new ResponseBuffers(replyHeader, responseBuffer), null);
                }
                catch (Throwable localThrowable) {
                    MessageHeaderCallback.this.callback.onResult(null, localThrowable);
                }
            }
        }
    }
}

