/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.bulk.InsertRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.LegacyMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.OpCode;
import me.lucko.helper.mongo.external.mongodriver.connection.RequestMessage;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.CollectibleDocumentFieldNameValidator;

class InsertMessage
extends LegacyMessage {
    private final InsertRequest insertRequest;

    InsertMessage(String collectionName, InsertRequest insertRequest, MessageSettings settings) {
        super(collectionName, OpCode.OP_INSERT, settings);
        this.insertRequest = insertRequest;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput outputStream) {
        this.writeInsertPrologue(outputStream);
        int firstDocumentPosition = outputStream.getPosition();
        this.addCollectibleDocument(this.insertRequest.getDocument(), outputStream, new CollectibleDocumentFieldNameValidator());
        return new RequestMessage.EncodingMetadata(firstDocumentPosition);
    }

    private void writeInsertPrologue(BsonOutput outputStream) {
        outputStream.writeInt32(0);
        outputStream.writeCString(this.getCollectionName());
    }
}

