/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonBinaryWriter;
import me.lucko.helper.mongo.external.bson.BsonElement;
import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.mongodriver.connection.BsonWriterHelper;
import me.lucko.helper.mongo.external.mongodriver.connection.LevelCountingBsonWriter;

class ElementExtendingBsonWriter
extends LevelCountingBsonWriter {
    private final List<BsonElement> extraElements;

    ElementExtendingBsonWriter(BsonBinaryWriter writer, List<BsonElement> extraElements) {
        super(writer);
        this.extraElements = extraElements;
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0) {
            BsonWriterHelper.writeElements(this.getBsonBinaryWriter(), this.extraElements);
        }
        super.writeEndDocument();
    }

    @Override
    public void pipe(BsonReader reader) {
        if (this.getCurrentLevel() == -1) {
            this.getBsonBinaryWriter().pipe(reader, this.extraElements);
        } else {
            this.getBsonBinaryWriter().pipe(reader);
        }
    }
}

