/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.Collections;
import me.lucko.helper.mongo.external.bson.BsonArray;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt32;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcernResult;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.bulk.DeleteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.ByteBufBsonDocument;
import me.lucko.helper.mongo.external.mongodriver.connection.ByteBufferBsonOutput;
import me.lucko.helper.mongo.external.mongodriver.connection.DeleteMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.RequestMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.WriteProtocol;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Logger;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Loggers;

class DeleteProtocol
extends WriteProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.delete");
    private final DeleteRequest deleteRequest;

    DeleteProtocol(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest) {
        super(namespace, ordered);
        this.deleteRequest = deleteRequest;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Deleting documents from namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        WriteConcernResult writeConcernResult = super.execute(connection);
        LOGGER.debug("Delete completed");
        return writeConcernResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously deleting documents in namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<WriteConcernResult>(){

                @Override
                public void onResult(WriteConcernResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous delete completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected BsonDocument getAsWriteCommand(ByteBufferBsonOutput bsonOutput, int firstDocumentPosition) {
        BsonDocument deleteDocument = new BsonDocument("q", ByteBufBsonDocument.createOne(bsonOutput, firstDocumentPosition)).append("limit", this.deleteRequest.isMulti() ? new BsonInt32(0) : new BsonInt32(1));
        return this.getBaseCommandDocument("delete").append("deletes", new BsonArray(Collections.singletonList(deleteDocument)));
    }

    @Override
    protected RequestMessage createRequestMessage(MessageSettings settings) {
        return new DeleteMessage(this.getNamespace().getFullName(), this.deleteRequest, settings);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

