/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.MongoCompressor;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.client.MongoDriverInformation;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterClock;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterId;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterableServer;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterableServerFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionPoolSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.DefaultConnectionFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.DefaultConnectionPool;
import me.lucko.helper.mongo.external.mongodriver.connection.DefaultServer;
import me.lucko.helper.mongo.external.mongodriver.connection.DefaultServerMonitorFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalStreamConnectionFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerId;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.StreamFactory;
import me.lucko.helper.mongo.external.mongodriver.event.CommandListener;
import me.lucko.helper.mongo.external.mongodriver.event.ServerListener;

class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ClusterId clusterId;
    private final ClusterSettings clusterSettings;
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final StreamFactory streamFactory;
    private final List<MongoCredential> credentialList;
    private final StreamFactory heartbeatStreamFactory;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;

    DefaultClusterableServerFactory(ClusterId clusterId, ClusterSettings clusterSettings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList) {
        this.clusterId = clusterId;
        this.clusterSettings = clusterSettings;
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credentialList = credentialList;
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
    }

    @Override
    public ClusterableServer create(ServerAddress serverAddress, ServerListener serverListener, ClusterClock clusterClock) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(this.clusterId, serverAddress), new InternalStreamConnectionFactory(this.streamFactory, this.credentialList, this.applicationName, this.mongoDriverInformation, this.compressorList, this.commandListener), this.connectionPoolSettings);
        DefaultServerMonitorFactory serverMonitorFactory = new DefaultServerMonitorFactory(new ServerId(this.clusterId, serverAddress), this.serverSettings, clusterClock, new InternalStreamConnectionFactory(this.heartbeatStreamFactory, this.credentialList, this.applicationName, this.mongoDriverInformation, Collections.<MongoCompressor>emptyList(), null), connectionPool);
        return new DefaultServer(new ServerId(this.clusterId, serverAddress), this.clusterSettings.getMode(), connectionPool, new DefaultConnectionFactory(), serverMonitorFactory, serverListener, this.commandListener, clusterClock);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

