/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.MongoCompressor;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.client.MongoDriverInformation;
import me.lucko.helper.mongo.external.mongodriver.connection.Cluster;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterConnectionMode;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterId;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionPoolSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.DefaultClusterableServerFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.MultiServerCluster;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.SingleServerCluster;
import me.lucko.helper.mongo.external.mongodriver.connection.StreamFactory;
import me.lucko.helper.mongo.external.mongodriver.event.ClusterListener;
import me.lucko.helper.mongo.external.mongodriver.event.CommandListener;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionListener;
import me.lucko.helper.mongo.external.mongodriver.event.ConnectionPoolListener;

public final class DefaultClusterFactory
implements ClusterFactory {
    @Override
    public Cluster create(ClusterSettings settings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, ClusterListener clusterListener, ConnectionPoolListener connectionPoolListener, ConnectionListener connectionListener) {
        return this.createCluster(this.getClusterSettings(settings, clusterListener), serverSettings, this.getConnectionPoolSettings(connectionPoolSettings, connectionPoolListener), streamFactory, heartbeatStreamFactory, credentialList, null, null, null, Collections.<MongoCompressor>emptyList());
    }

    @Deprecated
    public Cluster create(ClusterSettings settings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, ClusterListener clusterListener, ConnectionPoolListener connectionPoolListener, ConnectionListener connectionListener, CommandListener commandListener) {
        return this.createCluster(this.getClusterSettings(settings, clusterListener), serverSettings, this.getConnectionPoolSettings(connectionPoolSettings, connectionPoolListener), streamFactory, heartbeatStreamFactory, credentialList, commandListener, null, null, Collections.<MongoCompressor>emptyList());
    }

    @Deprecated
    public Cluster create(ClusterSettings settings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, ClusterListener clusterListener, ConnectionPoolListener connectionPoolListener, ConnectionListener connectionListener, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation) {
        return this.createCluster(this.getClusterSettings(settings, clusterListener), serverSettings, this.getConnectionPoolSettings(connectionPoolSettings, connectionPoolListener), streamFactory, heartbeatStreamFactory, credentialList, commandListener, applicationName, mongoDriverInformation, Collections.<MongoCompressor>emptyList());
    }

    @Deprecated
    public Cluster createCluster(ClusterSettings clusterSettings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation) {
        return this.createCluster(clusterSettings, serverSettings, connectionPoolSettings, streamFactory, heartbeatStreamFactory, credentialList, commandListener, applicationName, mongoDriverInformation, Collections.<MongoCompressor>emptyList());
    }

    public Cluster createCluster(ClusterSettings clusterSettings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, CommandListener commandListener, String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList) {
        ClusterId clusterId = new ClusterId(clusterSettings.getDescription());
        DefaultClusterableServerFactory serverFactory = new DefaultClusterableServerFactory(clusterId, clusterSettings, serverSettings, connectionPoolSettings, streamFactory, heartbeatStreamFactory, credentialList, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList);
        if (clusterSettings.getMode() == ClusterConnectionMode.SINGLE) {
            return new SingleServerCluster(clusterId, clusterSettings, serverFactory);
        }
        if (clusterSettings.getMode() == ClusterConnectionMode.MULTIPLE) {
            return new MultiServerCluster(clusterId, clusterSettings, serverFactory);
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)clusterSettings.getMode()));
    }

    private ClusterSettings getClusterSettings(ClusterSettings settings, ClusterListener clusterListener) {
        return ClusterSettings.builder(settings).addClusterListener(clusterListener).build();
    }

    private ConnectionPoolSettings getConnectionPoolSettings(ConnectionPoolSettings connPoolSettings, ConnectionPoolListener connPoolListener) {
        return ConnectionPoolSettings.builder(connPoolSettings).addConnectionPoolListener(connPoolListener).build();
    }
}

