/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.FieldNameValidator;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.connection.CommandMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.CommandProtocol;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.ProtocolHelper;
import me.lucko.helper.mongo.external.mongodriver.connection.SplittablePayload;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Logger;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Loggers;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

class CommandProtocolImpl<T>
implements CommandProtocol<T> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final SplittablePayload payload;
    private final ReadPreference readPreference;
    private final FieldNameValidator commandFieldNameValidator;
    private final FieldNameValidator payloadFieldNameValidator;
    private final Decoder<T> commandResultDecoder;
    private final boolean responseExpected;
    private SessionContext sessionContext;

    CommandProtocolImpl(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder) {
        this(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, true, null, null);
    }

    CommandProtocolImpl(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, boolean responseExpected, SplittablePayload payload, FieldNameValidator payloadFieldNameValidator) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(Assertions.notNull("database", database), "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandFieldNameValidator = Assertions.notNull("commandFieldNameValidator", commandFieldNameValidator);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.responseExpected = responseExpected;
        this.payload = payload;
        this.payloadFieldNameValidator = payloadFieldNameValidator;
        Assertions.isTrueArgument("payloadFieldNameValidator cannot be null if there is a payload.", payload == null || payloadFieldNameValidator != null);
    }

    @Override
    public T execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        T retval = connection.sendAndReceive(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext);
        LOGGER.debug("Command execution completed");
        return retval;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<T> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            connection.sendAndReceiveAsync(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext, new SingleResultCallback<T>(){

                @Override
                public void onResult(T result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    public CommandProtocolImpl<T> sessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }

    private CommandMessage getCommandMessage(InternalConnection connection) {
        return new CommandMessage(this.namespace, this.command, this.commandFieldNameValidator, this.readPreference, ProtocolHelper.getMessageSettings(connection.getDescription()), this.responseExpected, this.payload, this.payloadFieldNameValidator);
    }

    private String getCommandName() {
        return this.command.keySet().iterator().next();
    }
}

