/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.client.model.geojson;

import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.CoordinateReferenceSystem;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.GeoJsonObjectType;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.Geometry;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.Position;

public final class MultiPoint
extends Geometry {
    private final List<Position> coordinates;

    public MultiPoint(List<Position> coordinates) {
        this(null, coordinates);
    }

    public MultiPoint(CoordinateReferenceSystem coordinateReferenceSystem, List<Position> coordinates) {
        super(coordinateReferenceSystem);
        Assertions.notNull("coordinates", coordinates);
        Assertions.isTrueArgument("coordinates contains only non-null positions", !coordinates.contains(null));
        this.coordinates = Collections.unmodifiableList(coordinates);
    }

    @Override
    public GeoJsonObjectType getType() {
        return GeoJsonObjectType.MULTI_POINT;
    }

    public List<Position> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiPoint multiPoint = (MultiPoint)o;
        return this.coordinates.equals(multiPoint.coordinates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + this.coordinates.hashCode();
    }

    public String toString() {
        return "MultiPoint{coordinates=" + this.coordinates + (this.getCoordinateReferenceSystem() == null ? "" : ", coordinateReferenceSystem=" + this.getCoordinateReferenceSystem()) + '}';
    }
}

