/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.client.model.changestream;

import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistries;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.codecs.pojo.ClassModel;
import me.lucko.helper.mongo.external.bson.codecs.pojo.ClassModelBuilder;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PojoCodecProvider;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.client.model.changestream.ChangeStreamDocument;
import me.lucko.helper.mongo.external.mongodriver.client.model.changestream.OperationTypeCodec;
import me.lucko.helper.mongo.external.mongodriver.client.model.changestream.UpdateDescription;

final class ChangeStreamDocumentCodec<TResult>
implements Codec<ChangeStreamDocument<TResult>> {
    private static final BsonDocumentCodec BSON_DOCUMENT_CODEC = new BsonDocumentCodec();
    private static final OperationTypeCodec OPERATION_TYPE_CODEC = new OperationTypeCodec();
    private final Codec<ChangeStreamDocument<TResult>> codec;

    ChangeStreamDocumentCodec(Class<TResult> fullDocumentClass, CodecRegistry codecRegistry) {
        ClassModelBuilder<ChangeStreamDocument> classModelBuilder = ClassModel.builder(ChangeStreamDocument.class);
        classModelBuilder.getProperty("documentKey").codec(BSON_DOCUMENT_CODEC);
        classModelBuilder.getProperty("fullDocument").codec(codecRegistry.get(fullDocumentClass));
        classModelBuilder.getProperty("resumeToken").codec(BSON_DOCUMENT_CODEC);
        classModelBuilder.getProperty("operationType").codec(OPERATION_TYPE_CODEC);
        ClassModel<ChangeStreamDocument> changeStreamDocumentClassModel = classModelBuilder.build();
        PojoCodecProvider provider = PojoCodecProvider.builder().register(MongoNamespace.class).register(UpdateDescription.class).register(changeStreamDocumentClassModel).build();
        CodecRegistry registry = CodecRegistries.fromRegistries(codecRegistry, CodecRegistries.fromProviders(provider));
        this.codec = registry.get(ChangeStreamDocument.class);
    }

    @Override
    public ChangeStreamDocument<TResult> decode(BsonReader reader, DecoderContext decoderContext) {
        return (ChangeStreamDocument)this.codec.decode(reader, decoderContext);
    }

    @Override
    public void encode(BsonWriter writer, ChangeStreamDocument<TResult> value, EncoderContext encoderContext) {
        this.codec.encode(writer, value, encoderContext);
    }

    @Override
    public Class<ChangeStreamDocument<TResult>> getEncoderClass() {
        return ChangeStreamDocument.class;
    }
}

