/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.client.model;

import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;

public class DBCollectionCountOptions {
    private DBObject hint;
    private String hintString;
    private int limit;
    private int skip;
    private long maxTimeMS;
    private ReadPreference readPreference;
    private ReadConcern readConcern;
    private Collation collation;

    public DBObject getHint() {
        return this.hint;
    }

    public String getHintString() {
        return this.hintString;
    }

    public DBCollectionCountOptions hint(DBObject hint) {
        this.hint = hint;
        return this;
    }

    public DBCollectionCountOptions hintString(String hint) {
        this.hintString = hint;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public DBCollectionCountOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public DBCollectionCountOptions skip(int skip) {
        this.skip = skip;
        return this;
    }

    public DBCollectionCountOptions limit(long limit) {
        Assertions.isTrue("limit is too large", limit <= Integer.MAX_VALUE);
        this.limit = (int)limit;
        return this;
    }

    public DBCollectionCountOptions skip(long skip) {
        Assertions.isTrue("skip is too large", skip <= Integer.MAX_VALUE);
        this.skip = (int)skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DBCollectionCountOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public DBCollectionCountOptions readPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public DBCollectionCountOptions readConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public DBCollectionCountOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }
}

