/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.client;

import java.util.List;
import me.lucko.helper.mongo.external.bson.Document;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.conversions.Bson;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.annotations.ThreadSafe;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.client.AggregateIterable;
import me.lucko.helper.mongo.external.mongodriver.client.ChangeStreamIterable;
import me.lucko.helper.mongo.external.mongodriver.client.DistinctIterable;
import me.lucko.helper.mongo.external.mongodriver.client.FindIterable;
import me.lucko.helper.mongo.external.mongodriver.client.ListIndexesIterable;
import me.lucko.helper.mongo.external.mongodriver.client.MapReduceIterable;
import me.lucko.helper.mongo.external.mongodriver.client.model.BulkWriteOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.CountOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.CreateIndexOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.DeleteOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.DropIndexOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.FindOneAndDeleteOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.FindOneAndReplaceOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.FindOneAndUpdateOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.IndexModel;
import me.lucko.helper.mongo.external.mongodriver.client.model.IndexOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.InsertManyOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.InsertOneOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.RenameCollectionOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.UpdateOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.WriteModel;
import me.lucko.helper.mongo.external.mongodriver.client.result.DeleteResult;
import me.lucko.helper.mongo.external.mongodriver.client.result.UpdateResult;
import me.lucko.helper.mongo.external.mongodriver.session.ClientSession;

@ThreadSafe
public interface MongoCollection<TDocument> {
    public MongoNamespace getNamespace();

    public Class<TDocument> getDocumentClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<TDocument> withReadPreference(ReadPreference var1);

    public MongoCollection<TDocument> withWriteConcern(WriteConcern var1);

    public MongoCollection<TDocument> withReadConcern(ReadConcern var1);

    public long count();

    public long count(Bson var1);

    public long count(Bson var1, CountOptions var2);

    public long count(ClientSession var1);

    public long count(ClientSession var1, Bson var2);

    public long count(ClientSession var1, Bson var2, CountOptions var3);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Class<TResult> var2);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Bson var2, Class<TResult> var3);

    public <TResult> DistinctIterable<TResult> distinct(ClientSession var1, String var2, Class<TResult> var3);

    public <TResult> DistinctIterable<TResult> distinct(ClientSession var1, String var2, Bson var3, Class<TResult> var4);

    public FindIterable<TDocument> find();

    public <TResult> FindIterable<TResult> find(Class<TResult> var1);

    public FindIterable<TDocument> find(Bson var1);

    public <TResult> FindIterable<TResult> find(Bson var1, Class<TResult> var2);

    public FindIterable<TDocument> find(ClientSession var1);

    public <TResult> FindIterable<TResult> find(ClientSession var1, Class<TResult> var2);

    public FindIterable<TDocument> find(ClientSession var1, Bson var2);

    public <TResult> FindIterable<TResult> find(ClientSession var1, Bson var2, Class<TResult> var3);

    public AggregateIterable<TDocument> aggregate(List<? extends Bson> var1);

    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public AggregateIterable<TDocument> aggregate(ClientSession var1, List<? extends Bson> var2);

    public <TResult> AggregateIterable<TResult> aggregate(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public ChangeStreamIterable<TDocument> watch();

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> var1);

    public ChangeStreamIterable<TDocument> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamIterable<TDocument> watch(ClientSession var1);

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamIterable<TDocument> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public MapReduceIterable<TDocument> mapReduce(String var1, String var2);

    public <TResult> MapReduceIterable<TResult> mapReduce(String var1, String var2, Class<TResult> var3);

    public MapReduceIterable<TDocument> mapReduce(ClientSession var1, String var2, String var3);

    public <TResult> MapReduceIterable<TResult> mapReduce(ClientSession var1, String var2, String var3, Class<TResult> var4);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> var1);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, BulkWriteOptions var2);

    public BulkWriteResult bulkWrite(ClientSession var1, List<? extends WriteModel<? extends TDocument>> var2);

    public BulkWriteResult bulkWrite(ClientSession var1, List<? extends WriteModel<? extends TDocument>> var2, BulkWriteOptions var3);

    public void insertOne(TDocument var1);

    public void insertOne(TDocument var1, InsertOneOptions var2);

    public void insertOne(ClientSession var1, TDocument var2);

    public void insertOne(ClientSession var1, TDocument var2, InsertOneOptions var3);

    public void insertMany(List<? extends TDocument> var1);

    public void insertMany(List<? extends TDocument> var1, InsertManyOptions var2);

    public void insertMany(ClientSession var1, List<? extends TDocument> var2);

    public void insertMany(ClientSession var1, List<? extends TDocument> var2, InsertManyOptions var3);

    public DeleteResult deleteOne(Bson var1);

    public DeleteResult deleteOne(Bson var1, DeleteOptions var2);

    public DeleteResult deleteOne(ClientSession var1, Bson var2);

    public DeleteResult deleteOne(ClientSession var1, Bson var2, DeleteOptions var3);

    public DeleteResult deleteMany(Bson var1);

    public DeleteResult deleteMany(Bson var1, DeleteOptions var2);

    public DeleteResult deleteMany(ClientSession var1, Bson var2);

    public DeleteResult deleteMany(ClientSession var1, Bson var2, DeleteOptions var3);

    public UpdateResult replaceOne(Bson var1, TDocument var2);

    public UpdateResult replaceOne(Bson var1, TDocument var2, UpdateOptions var3);

    public UpdateResult replaceOne(ClientSession var1, Bson var2, TDocument var3);

    public UpdateResult replaceOne(ClientSession var1, Bson var2, TDocument var3, UpdateOptions var4);

    public UpdateResult updateOne(Bson var1, Bson var2);

    public UpdateResult updateOne(Bson var1, Bson var2, UpdateOptions var3);

    public UpdateResult updateOne(ClientSession var1, Bson var2, Bson var3);

    public UpdateResult updateOne(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4);

    public UpdateResult updateMany(Bson var1, Bson var2);

    public UpdateResult updateMany(Bson var1, Bson var2, UpdateOptions var3);

    public UpdateResult updateMany(ClientSession var1, Bson var2, Bson var3);

    public UpdateResult updateMany(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4);

    public TDocument findOneAndDelete(Bson var1);

    public TDocument findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2);

    public TDocument findOneAndDelete(ClientSession var1, Bson var2);

    public TDocument findOneAndDelete(ClientSession var1, Bson var2, FindOneAndDeleteOptions var3);

    public TDocument findOneAndReplace(Bson var1, TDocument var2);

    public TDocument findOneAndReplace(Bson var1, TDocument var2, FindOneAndReplaceOptions var3);

    public TDocument findOneAndReplace(ClientSession var1, Bson var2, TDocument var3);

    public TDocument findOneAndReplace(ClientSession var1, Bson var2, TDocument var3, FindOneAndReplaceOptions var4);

    public TDocument findOneAndUpdate(Bson var1, Bson var2);

    public TDocument findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3);

    public TDocument findOneAndUpdate(ClientSession var1, Bson var2, Bson var3);

    public TDocument findOneAndUpdate(ClientSession var1, Bson var2, Bson var3, FindOneAndUpdateOptions var4);

    public void drop();

    public void drop(ClientSession var1);

    public String createIndex(Bson var1);

    public String createIndex(Bson var1, IndexOptions var2);

    public String createIndex(ClientSession var1, Bson var2);

    public String createIndex(ClientSession var1, Bson var2, IndexOptions var3);

    public List<String> createIndexes(List<IndexModel> var1);

    public List<String> createIndexes(List<IndexModel> var1, CreateIndexOptions var2);

    public List<String> createIndexes(ClientSession var1, List<IndexModel> var2);

    public List<String> createIndexes(ClientSession var1, List<IndexModel> var2, CreateIndexOptions var3);

    public ListIndexesIterable<Document> listIndexes();

    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> var1);

    public ListIndexesIterable<Document> listIndexes(ClientSession var1);

    public <TResult> ListIndexesIterable<TResult> listIndexes(ClientSession var1, Class<TResult> var2);

    public void dropIndex(String var1);

    public void dropIndex(String var1, DropIndexOptions var2);

    public void dropIndex(Bson var1);

    public void dropIndex(Bson var1, DropIndexOptions var2);

    public void dropIndex(ClientSession var1, String var2);

    public void dropIndex(ClientSession var1, Bson var2);

    public void dropIndex(ClientSession var1, String var2, DropIndexOptions var3);

    public void dropIndex(ClientSession var1, Bson var2, DropIndexOptions var3);

    public void dropIndexes();

    public void dropIndexes(ClientSession var1);

    public void dropIndexes(DropIndexOptions var1);

    public void dropIndexes(ClientSession var1, DropIndexOptions var2);

    public void renameCollection(MongoNamespace var1);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2);

    public void renameCollection(ClientSession var1, MongoNamespace var2);

    public void renameCollection(ClientSession var1, MongoNamespace var2, RenameCollectionOptions var3);
}

