/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.bulk;

import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;

public final class UpdateRequest
extends WriteRequest {
    private final BsonDocument update;
    private final WriteRequest.Type updateType;
    private final BsonDocument filter;
    private boolean isMulti = true;
    private boolean isUpsert = false;
    private Collation collation;
    private List<BsonDocument> arrayFilters;

    public UpdateRequest(BsonDocument filter, BsonDocument update, WriteRequest.Type updateType) {
        if (updateType != WriteRequest.Type.UPDATE && updateType != WriteRequest.Type.REPLACE) {
            throw new IllegalArgumentException("Update type must be UPDATE or REPLACE");
        }
        this.filter = Assertions.notNull("filter", filter);
        this.update = Assertions.notNull("update", update);
        this.updateType = updateType;
        this.isMulti = updateType == WriteRequest.Type.UPDATE;
    }

    @Override
    public WriteRequest.Type getType() {
        return this.updateType;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public BsonDocument getUpdate() {
        return this.update;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public UpdateRequest multi(boolean isMulti) {
        if (isMulti && this.updateType == WriteRequest.Type.REPLACE) {
            throw new IllegalArgumentException("Replacements can not be multi");
        }
        this.isMulti = isMulti;
        return this;
    }

    public boolean isUpsert() {
        return this.isUpsert;
    }

    public UpdateRequest upsert(boolean isUpsert) {
        this.isUpsert = isUpsert;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public UpdateRequest collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public UpdateRequest arrayFilters(List<BsonDocument> arrayFilters) {
        this.arrayFilters = arrayFilters;
        return this;
    }

    public List<BsonDocument> getArrayFilters() {
        return this.arrayFilters;
    }
}

