/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonDocumentWrapper;
import me.lucko.helper.mongo.external.bson.codecs.Encoder;
import me.lucko.helper.mongo.external.mongodriver.DBCollection;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;

class UpdateRequest
extends WriteRequest {
    private final DBObject query;
    private final DBObject update;
    private final boolean multi;
    private final boolean upsert;
    private final Encoder<DBObject> codec;
    private final Collation collation;
    private final List<? extends DBObject> arrayFilters;

    UpdateRequest(DBObject query, DBObject update, boolean multi, boolean upsert, Encoder<DBObject> codec, Collation collation, List<? extends DBObject> arrayFilters) {
        this.query = query;
        this.update = update;
        this.multi = multi;
        this.upsert = upsert;
        this.codec = codec;
        this.collation = collation;
        this.arrayFilters = arrayFilters;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public DBObject getUpdate() {
        return this.update;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public List<? extends DBObject> getArrayFilters() {
        return this.arrayFilters;
    }

    @Override
    me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest toNew(DBCollection dbCollection) {
        return new me.lucko.helper.mongo.external.mongodriver.bulk.UpdateRequest(new BsonDocumentWrapper<DBObject>(this.query, this.codec), new BsonDocumentWrapper<DBObject>(this.update, this.codec), WriteRequest.Type.UPDATE).upsert(this.isUpsert()).multi(this.isMulti()).collation(this.getCollation()).arrayFilters(dbCollection.wrapAllowNull(this.arrayFilters, this.codec));
    }
}

