/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.connection.Cluster;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;

public class ReplicaSetStatus {
    private final Cluster cluster;

    ReplicaSetStatus(Cluster cluster) {
        this.cluster = cluster;
    }

    public String getName() {
        List<ServerDescription> any = this.getClusterDescription().getAnyPrimaryOrSecondary();
        return any.isEmpty() ? null : any.get(0).getSetName();
    }

    public ServerAddress getMaster() {
        List<ServerDescription> primaries = this.getClusterDescription().getPrimaries();
        return primaries.isEmpty() ? null : primaries.get(0).getAddress();
    }

    public boolean isMaster(ServerAddress serverAddress) {
        return this.getMaster().equals(serverAddress);
    }

    public int getMaxBsonObjectSize() {
        List<ServerDescription> primaries = this.getClusterDescription().getPrimaries();
        return primaries.isEmpty() ? ServerDescription.getDefaultMaxDocumentSize() : primaries.get(0).getMaxDocumentSize();
    }

    private ClusterDescription getClusterDescription() {
        return this.cluster.getDescription();
    }

    public String toString() {
        return "ReplicaSetStatus{name=" + this.getName() + ", cluster=" + this.getClusterDescription() + '}';
    }
}

