/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;

public enum ReadConcernLevel {
    LOCAL("local"),
    MAJORITY("majority"),
    LINEARIZABLE("linearizable");

    private final String value;

    private ReadConcernLevel(String readConcernLevel) {
        this.value = readConcernLevel;
    }

    public String getValue() {
        return this.value;
    }

    public static ReadConcernLevel fromString(String readConcernLevel) {
        Assertions.notNull("readConcernLevel", readConcernLevel);
        for (ReadConcernLevel level : ReadConcernLevel.values()) {
            if (!readConcernLevel.equalsIgnoreCase(level.value)) continue;
            return level;
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid readConcernLevel", readConcernLevel));
    }
}

