/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.mongodriver.Function;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.ServerCursor;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.MongoCursor;

class MongoMappingCursor<T, U>
implements MongoCursor<U> {
    private final MongoCursor<T> proxied;
    private final Function<T, U> mapper;

    MongoMappingCursor(MongoCursor<T> proxied, Function<T, U> mapper) {
        this.proxied = Assertions.notNull("proxied", proxied);
        this.mapper = Assertions.notNull("mapper", mapper);
    }

    @Override
    public void close() {
        this.proxied.close();
    }

    @Override
    public boolean hasNext() {
        return this.proxied.hasNext();
    }

    @Override
    public U next() {
        return this.mapper.apply(this.proxied.next());
    }

    @Override
    public U tryNext() {
        T proxiedNext = this.proxied.tryNext();
        if (proxiedNext == null) {
            return null;
        }
        return this.mapper.apply(proxiedNext);
    }

    @Override
    public void remove() {
        this.proxied.remove();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.proxied.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.proxied.getServerAddress();
    }
}

