/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.Collection;
import java.util.Iterator;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.conversions.Bson;
import me.lucko.helper.mongo.external.mongodriver.Block;
import me.lucko.helper.mongo.external.mongodriver.Function;
import me.lucko.helper.mongo.external.mongodriver.MappingIterable;
import me.lucko.helper.mongo.external.mongodriver.MongoBatchCursorAdapter;
import me.lucko.helper.mongo.external.mongodriver.OperationExecutor;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.MongoCursor;
import me.lucko.helper.mongo.external.mongodriver.client.MongoIterable;
import me.lucko.helper.mongo.external.mongodriver.operation.BatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;
import me.lucko.helper.mongo.external.mongodriver.session.ClientSession;

abstract class MongoIterableImpl<TResult>
implements MongoIterable<TResult> {
    private final ClientSession clientSession;
    private final ReadConcern readConcern;
    private OperationExecutor executor;
    private ReadPreference readPreference;
    private Integer batchSize;

    MongoIterableImpl(ClientSession clientSession, OperationExecutor executor, ReadConcern readConcern, ReadPreference readPreference) {
        this.clientSession = clientSession;
        this.executor = Assertions.notNull("executor", executor);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
    }

    abstract ReadOperation<BatchCursor<TResult>> asReadOperation();

    ClientSession getClientSession() {
        return this.clientSession;
    }

    OperationExecutor getExecutor() {
        return this.executor;
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public MongoIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return new MongoBatchCursorAdapter<TResult>(this.execute());
    }

    @Override
    public TResult first() {
        Iterator cursor = this.iterator();
        try {
            if (!cursor.hasNext()) {
                TResult TResult = null;
                return TResult;
            }
            Object TResult = cursor.next();
            return TResult;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        Iterator cursor = this.iterator();
        try {
            while (cursor.hasNext()) {
                block.apply(cursor.next());
            }
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public <A extends Collection<? super TResult>> A into(final A target) {
        this.forEach(new Block<TResult>(){

            @Override
            public void apply(TResult t) {
                target.add(t);
            }
        });
        return target;
    }

    BsonDocument toBsonDocumentOrNull(Bson document, CodecRegistry codecRegistry) {
        return this.toBsonDocumentOrNull(document, BsonDocument.class, codecRegistry);
    }

    <T> BsonDocument toBsonDocumentOrNull(Bson document, Class<T> documentClass, CodecRegistry codecRegistry) {
        return document == null ? null : document.toBsonDocument(documentClass, codecRegistry);
    }

    private BatchCursor<TResult> execute() {
        return this.executor.execute(this.asReadOperation(), this.readPreference, this.clientSession);
    }
}

