/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;

public final class MongoCompressor {
    public static final String LEVEL = "LEVEL";
    private final String name;
    private final Map<String, Object> properties;

    public static MongoCompressor createSnappyCompressor() {
        return new MongoCompressor("snappy");
    }

    public static MongoCompressor createZlibCompressor() {
        return new MongoCompressor("zlib");
    }

    public String getName() {
        return this.name;
    }

    public <T> T getProperty(String key, T defaultValue) {
        Assertions.notNull("key", key);
        Object value = this.properties.get(key.toLowerCase());
        return (T)(value == null && !this.properties.containsKey(key) ? defaultValue : value);
    }

    public <T> MongoCompressor withProperty(String key, T value) {
        return new MongoCompressor(this, key, value);
    }

    private MongoCompressor(String name) {
        this.name = name;
        this.properties = Collections.emptyMap();
    }

    private <T> MongoCompressor(MongoCompressor from, String propertyKey, T propertyValue) {
        Assertions.notNull("propertyKey", propertyKey);
        this.name = from.name;
        this.properties = new HashMap<String, Object>(from.properties);
        this.properties.put(propertyKey.toLowerCase(), propertyValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoCompressor that = (MongoCompressor)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    public String toString() {
        return "MongoCompressor{name='" + this.name + '\'' + ", properties=" + this.properties + '}';
    }
}

