/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.Document;
import me.lucko.helper.mongo.external.bson.codecs.BsonValueCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.DocumentCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.IterableCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.MapCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.ValueCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistries;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.mongodriver.ClientSessionOptions;
import me.lucko.helper.mongo.external.mongodriver.DBObjectCodec;
import me.lucko.helper.mongo.external.mongodriver.DBObjectCodecProvider;
import me.lucko.helper.mongo.external.mongodriver.DBRefCodecProvider;
import me.lucko.helper.mongo.external.mongodriver.DocumentToDBRefTransformer;
import me.lucko.helper.mongo.external.mongodriver.Function;
import me.lucko.helper.mongo.external.mongodriver.ListDatabasesIterableImpl;
import me.lucko.helper.mongo.external.mongodriver.Mongo;
import me.lucko.helper.mongo.external.mongodriver.MongoClientException;
import me.lucko.helper.mongo.external.mongodriver.MongoClientOptions;
import me.lucko.helper.mongo.external.mongodriver.MongoClientURI;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.MongoDatabaseImpl;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.ListDatabasesIterable;
import me.lucko.helper.mongo.external.mongodriver.client.MongoDatabase;
import me.lucko.helper.mongo.external.mongodriver.client.MongoDriverInformation;
import me.lucko.helper.mongo.external.mongodriver.client.MongoIterable;
import me.lucko.helper.mongo.external.mongodriver.client.gridfs.codecs.GridFSFileCodecProvider;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.codecs.GeoJsonCodecProvider;
import me.lucko.helper.mongo.external.mongodriver.session.ClientSession;

public class MongoClient
extends Mongo
implements Closeable {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DBRefCodecProvider(), new DBObjectCodecProvider(), new DocumentCodecProvider(new DocumentToDBRefTransformer()), new IterableCodecProvider(new DocumentToDBRefTransformer()), new MapCodecProvider(new DocumentToDBRefTransformer()), new GeoJsonCodecProvider(), new GridFSFileCodecProvider()));

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    public MongoClient() {
        this(new ServerAddress());
    }

    public MongoClient(String host) {
        this(new ServerAddress(host));
    }

    public MongoClient(String host, MongoClientOptions options) {
        this(new ServerAddress(host), options);
    }

    public MongoClient(String host, int port) {
        this(new ServerAddress(host, port));
    }

    public MongoClient(ServerAddress addr) {
        this(addr, new MongoClientOptions.Builder().build());
    }

    @Deprecated
    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList) {
        this(addr, credentialsList, MongoClientOptions.builder().build());
    }

    public MongoClient(ServerAddress addr, MongoClientOptions options) {
        super(addr, options);
    }

    @Deprecated
    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(addr, credentialsList, options);
    }

    public MongoClient(ServerAddress addr, MongoCredential credential, MongoClientOptions options) {
        super(addr, Collections.singletonList(credential), options);
    }

    public MongoClient(List<ServerAddress> seeds) {
        this(seeds, new MongoClientOptions.Builder().build());
    }

    @Deprecated
    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this(seeds, credentialsList, new MongoClientOptions.Builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, MongoClientOptions options) {
        super(seeds, options);
    }

    @Deprecated
    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(seeds, credentialsList, options);
    }

    public MongoClient(List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options) {
        super(seeds, Collections.singletonList(credential), options);
    }

    public MongoClient(MongoClientURI uri) {
        super(uri);
    }

    public MongoClient(MongoClientURI uri, MongoDriverInformation mongoDriverInformation) {
        super(uri, mongoDriverInformation);
    }

    @Deprecated
    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(addr, credentialsList, options, mongoDriverInformation);
    }

    public MongoClient(ServerAddress addr, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(addr, Collections.singletonList(credential), options, mongoDriverInformation);
    }

    @Deprecated
    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, credentialsList, options, mongoDriverInformation);
    }

    public MongoClient(List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, Collections.singletonList(credential), options, mongoDriverInformation);
    }

    @Override
    public MongoClientOptions getMongoClientOptions() {
        return super.getMongoClientOptions();
    }

    @Override
    public List<MongoCredential> getCredentialsList() {
        return super.getCredentialsList();
    }

    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    private MongoIterable<String> createListDatabaseNamesIterable(ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(new Function<BsonDocument, String>(){

            @Override
            public String apply(BsonDocument result) {
                return result.getString("name").getValue();
            }
        });
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return this.createListDatabasesIterable(null, clazz);
    }

    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabasesIterable(clientSession, clazz);
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.getMongoClientOptions().getCodecRegistry(), ReadPreference.primary(), this.createOperationExecutor());
    }

    public MongoDatabase getDatabase(String databaseName) {
        MongoClientOptions clientOptions = this.getMongoClientOptions();
        return new MongoDatabaseImpl(databaseName, clientOptions.getCodecRegistry(), clientOptions.getReadPreference(), clientOptions.getWriteConcern(), clientOptions.getRetryWrites(), clientOptions.getReadConcern(), this.createOperationExecutor());
    }

    public ClientSession startSession(ClientSessionOptions options) {
        ClientSession clientSession = this.createClientSession(Assertions.notNull("options", options));
        if (clientSession == null) {
            throw new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected");
        }
        return clientSession;
    }

    static DBObjectCodec getCommandCodec() {
        return new DBObjectCodec(MongoClient.getDefaultCodecRegistry());
    }
}

